# -------------------------------------------------------------------------------------
# MKDoc::CGI
# -------------------------------------------------------------------------------------
#
#       Author : Jean-Michel Hiver (jhiver@mkdoc.com).
#    Copyright : (c) Jean-Michel Hiver, 2002.
# 
#      Unauthorized modification, use, reuse, distribution or redistribution
#      of this module is stricly forbidden.
#
#    Description:
#
#      This module is a subclass of CGI.pm, it fixes an Apache-related CGI.pm
#      bug and also marks all the incoming parameters as UTF-8 strings.
#
# -------------------------------------------------------------------------------------
package MKDoc::CGI::CompileMe;
use CGI qw(-compile :all);

package MKDoc::CGI;
use strict;
use warnings;
use Encode;
use base qw /CGI/;



sub get
{
    my $class = shift;
    $class = ref $class || $class;

    $::MKD_CGI ||= $class->new(); 
    return $::MKD_CGI;
}


##
# $self->self_url;
# ----------------
# Returns the URI of the current CGI object
##
sub self_url
{
    my $self = shift;    
    my $url = $self->url ( -relative  => 0,
			   -path_info => 1,
			   -query     => 1 );
    
    # remove the blah:80 like URIs
    $url =~ s/(.*?\:\/\/(?:.*?\@)?)(.*):80(?!\d)(.*)/$1$2$3/
        if ($url =~ /(.*?\:\/\/(?:.*?\@)?)(.*):80(?!\d)(.*)/);
    
    return $url;
}


sub delete
{
    my $self = shift;
    while (@_) { $self->SUPER::delete (shift()) };
}


sub is_upload
{
    my ($self, $param_name) = @_;
    my @param = grep(ref && fileno($_), $self->SUPER::param ($param_name));
    return unless @param; 
    return wantarray ? @param : $param[0];
}


# WARNING! For some reason, the incoming UTF-8 strings
# are not internally marked up as UTF-8 when they should... 
sub param
{
    my $self = shift;
    return $self->SUPER::param (@_) if ($self->is_upload (@_));
    
    if (wantarray)
    {
	my @res = $self->SUPER::param (@_);
	foreach my $element (@res)
	{
	    if (defined $element)
	    {
		my $tmp = Encode::decode ('UTF-8', $element);
		if (defined $tmp)
		{
		    $element = $tmp;
		}
	    }
	}
	return @res;
    }
    else
    {
	my $res = $self->SUPER::param (@_);
	if (ref $res and ref $res eq 'ARRAY')
	{
	    foreach my $element (@{$res})
	    {
		if (defined $_)
		{
		    my $tmp = Encode::decode ('UTF-8', $element);
		    if (defined $tmp)
		    {
			$element = $tmp;
			Encode::_utf8_on ($element);
		    }
		}
	    }
	}
	else
	{
	    my $tmp = Encode::decode ('UTF-8', $res);
	    if (defined $tmp)
	    {
		$res = $tmp;
		Encode::_utf8_on ($res);
	    }
	}
	
	return $res;
    }
}


# redirect() doesn't seem to work with CGI.pm 2.89
# this should fix for this particular version.
sub redirect
{
    my $self = shift;
    my $uri  = shift;
    my $res  = '';
    $res .= "Status: 302 Moved\n";
    $res .= "Location: $uri\n\n";
    return $res;
}


sub param_eq
{
    my $self  = shift;
    my $param = $self->param (shift());
    my $value = shift;
    return unless (defined $param);
    return unless (defined $value);
    return $param eq $value;
}


sub path_info_eq
{
    my $self  = shift;
    my $param = $self->path_info();
    my $value = shift;
    return unless (defined $param);
    return unless (defined $value);
    return $param eq $value;
}


sub path_info_equals
{
    my $self = shift;
    return $self->path_info_eq (@_);
}


sub path_info_starts_with
{
    my $self  = shift;
    my $param = $self->path_info();
    my $value = quotemeta (shift);
    return $param =~ /^$value/;
}


1;
