# -------------------------------------------------------------------------------------
# MKDoc::Error - Error flags module
# -------------------------------------------------------------------------------------
#
#       Author : Steve Purkis <spurkis@mkdoc.com>
#    Copyright : (c) 2002, MKDoc Holdings Ltd.
#
#      Unauthorized modification, use, reuse, distribution or redistribution
#      of this module is stricly forbidden.
#
#  Description :
#
#       An MKDoc::Error object is simply a hash.  You can use it as a
#       hash, or as an object (which is useful for Petal templates).
#       The only reason this class exists is to allow error flags to
#       'inherit' values, so setting:
#
#           some.nested.flags
#
#       Also sets:
#
#           some.nest, some.nested.fla, some, ...
#
#       And so on.  But this only works if you use methods ATM.
#
# -------------------------------------------------------------------------------------

package MKDoc::Error;

use strict;
use warnings;


##
# CLASS VARIABLES
# ===============
##

## Version (from CVS revision string).
our $VERSION = (split(/ /, '$Revision: 1.7 $'))[1];


## Boolean switch controlling debug printing to STDERR.
our $DEBUG = 0;



##
# CONSTRUCTOR
# ===========
#
# $obj = new flo::Record::Editor(@flags)
# --------------------------------------
#   Instantiates and returns a new object, setting all @flags.
##
sub new
{
    my $class = shift;
    $class    = ref($class) || $class;
    my $self  = bless {}, $class;
    $self->set($_) for (@_);
    return $self;
}


##
# $obj->exists( $flag )
# ---------------------
#   Check if $flag is set.
#   Returns true if the error flag is set.
##
sub exists
{
    my $self = shift;
    my $flag = quotemeta (shift);
    return grep /^$flag/, keys %{$self};
}


##
# $bool = $obj->has_errors()
# --------------------------
#   Returns number of errors flags set (for compat w/old flo::Errors).
##
sub has_errors
{
    my $self = shift;
    return (scalar keys(%$self));
}


##
# $obj = $obj->set( $flag [, $val] )
# ----------------------------------
#   Sets $flag to $value or 1.
#   Returns this object.
##
sub set
{
    my $self = shift;
    my $flag = shift;
    $self->{$flag} = shift || 1;
    return $self;
}


##
# $val = $obj->get( $flag )
# -------------------------
#   Returns value of $flag, if set (for compatability w/old flo::Errors).
##
sub get
{
    my $self = shift;
    my $flag = shift;
    return $self->{$flag} if (exists $self->{$flag});
    return scalar $self->exists($flag);
}



1;


__END__
