# -----------------------------------------------------------------------------
# MKDoc::Site::Check::RelationShips
# -----------------------------------------------------------------------------
# Author : Jean-Michel Hiver <jhiver@mkdoc.com>
# -----------------------------------------------------------------------------
package MKDoc::Site::Check::RelationShips;
use flo::Standard;
use strict;
use warnings;
use Carp;

our $fixMe = 0;


##
# $class->check();
# ----------------
# Checks for inconsistencies on the Redirect table.
##
sub check
{
    my $self = shift;
    $self->_check_document_audience();
    $self->_check_document();
    $self->_check_contributor();
    $self->_check_base_document();
    $self->_check_preference_language();
    $self->_check_preference_audience();
    $self->_check_preference();
    $self->_check_document_audience();
    $self->_check_document();
    $self->_check_base_document();
}


sub _check_base_document
{
    my $self = shift;
    $self->_check_foreign_key (
	Base_Document => 'Editor_ID',
	Editor        => 'ID',
       );
    $self->_check_foreign_key (
	Base_Document => 'Document_ID',
	Document      => 'ID',
       );
}


sub _check_contributor
{
    my $self = shift;
    $self->_check_foreign_key (
	Contributor => 'Editor_ID',
	Editor      => 'ID',
       );
    $self->_check_foreign_key (
	Contributor => 'Document_ID',
	Document    => 'ID',
       );
}


sub _check_document
{
    my $self = shift;
    $self->_check_foreign_key (
	Document => 'Editor_Created_ID',
	Editor   => 'ID',
       );
    $self->_check_foreign_key (
	Document => 'Editor_Last_Modified_ID',
	Editor   => 'ID',
       );
}


sub _check_document_audience
{
    my $self = shift;
    $self->_check_foreign_key (
	Document_Audience => 'Document_ID',
	Document          => 'ID',
       );
    $self->_check_foreign_key (
	Document_Audience => 'Audience_ID',
	Audience          => 'ID',
       );
}


sub _check_preference
{
    my $self = shift;
    $self->_check_foreign_key (
	Preference => 'Editor_ID',
	Editor     => 'ID',
       );
}


sub _check_preference_audience
{
    my $self = shift;
    $self->_check_foreign_key (
	Preference_Audience => 'Editor_ID',
	Editor              => 'ID',
       );
    $self->_check_foreign_key (
	Preference_Audience => 'Audience_ID',
	Audience            => 'ID',
       );
}


sub _check_preference_language
{
    my $self = shift;
    $self->_check_foreign_key (
	Preference_Language => 'Editor_ID',
	Editor              => 'ID',
       );
}


sub _check_foreign_key
{
    my $self = shift;
    my $referer_table_name  = shift || confess "\$referer_table_name not specified";
    my $referer_column_name = shift || confess "\$referer_column_name not specified";
    my $referee_table_name  = shift || confess "\$referee_table_name not specified";
    my $referee_column_name = shift || confess "\$referee_column_name not specified";
    my $update = shift;
    
    my $referer_t = flo::Standard::table ($referer_table_name);
    my $referee_t = flo::Standard::table ($referee_table_name);
    
    foreach my $referer ($referer_t->search()->fetch_all())
    {
	my $refering_value = $referer->{$referer_column_name};
	if (!$referee_t->get ( $referee_column_name => $refering_value ))
	{
	    my $err = join ' ', ( "$referer_table_name.$referer_column_name=$refering_value",
				  "=>",
				  "$referee_table_name.$referee_column_name corrupt" );
	    $self->_print ($err);
	    print "DELETE FROM $referer_table_name WHERE ID=$referer->{ID};\n";
	}
    }
}


sub _print
{
    my $self = shift;
    print STDERR join "\n", @_;
    print STDERR "\n";
}

1;


__END__
