# -----------------------------------------------------------------------------
# MKDoc::Site::ConfigWriter
# -----------------------------------------------------------------------------
#       Author : Jean-Michel Hiver <jhiver@mkdoc.com>
#    Copyright : Copyright (c) 2002 MKDoc Holdings Ltd.  All rights reserved.
#
#   Description:
#
#       Base class for modules which write configuration files.
#
# -----------------------------------------------------------------------------
package MKDoc::Site::ConfigWriter;
use strict;
use warnings;


##
# $thing->class();
# ----------------
# Returns the class or object's class.
##
sub class
{
    my $self = shift;
    return ref $self || $self;
}


##
# $class->site_public_domain();
# -----------------------------
# Returns the public domain of the website which is being setup.
# For instance, if $config->{PUBLIC_DOMAIN} is http://www.example.com/
# then this method will return 'www.example.com'.
##
sub site_public_domain
{
    my $class = shift->class;
    my $cfg = new MKDoc::Site::Config();
    my ($res) = $cfg->{PUBLIC_DOMAIN} =~ /https?\:\/\/(.*?)\/?$/;
    return $res;
}


##
# $class->site_user_domain();
# ---------------------------
# Returns the user domain of the website which is being setup.
# For instance, if $config->{USER_DOMAIN} is http://users.example.com/
# then this method will return 'users.example.com'.
##
sub site_user_domain
{
    my $class = shift->class;
    my $cfg = new MKDoc::Site::Config();
    my ($res) = $cfg->{USER_DOMAIN} =~ /https?\:\/\/(.*?)\/?$/;
    return $res;
}


##
# $class->is_site_public_domain_https();
# --------------------------------------
# Returns TRUE if the public site uses https,
# FALSE otherwise.
##
sub is_site_public_domain_https
{
    my $class = shift->class;
    my $cfg = new MKDoc::Site::Config();
    my $res = ($cfg->{PUBLIC_DOMAIN} =~ /^https\:\/\//) ? 1 : 0;
    return $res;
}


##
# $class->is_site_user_domain_https();
# ------------------------------------
# Returns TRUE if the user site uses https,
# FALSE otherwise.
##
sub is_site_user_domain_https
{
    my $class = shift->class;
    my $cfg = new MKDoc::Site::Config();
    my $res = ($cfg->{USER_DOMAIN} =~ /^https\:\/\//) ? 1 : 0;
    return $res;
}


1;


__END__
