# -----------------------------------------------------------------------------
# MKDoc::Site::ConfigWriter::MKDocRegistrer
# -----------------------------------------------------------------------------
# Author : Jean-Michel Hiver <jhiver@mkdoc.com>
# Copyright : Copyright (c) 2003 MKDoc Holdings Ltd.
# -----------------------------------------------------------------------------
package MKDoc::Site::ConfigWriter::MKDocRegistrer;
use strict;
use warnings;
use Carp;

use MKDoc::Site::Config;
use base qw /MKDoc::Site::ConfigWriter/;

sub class
{
    my $class = shift;
    return ref $class || $class;
}

##
# $class->setup();
# ----------------
# Writes the site.conf and httpd.conf and files.
##
sub setup
{
    my $class = shift;
    my $cfg = new MKDoc::Site::Config;
    
    my $mkdoc_dir = $cfg->{MKDOC_DIR};
    my $site_dir  = $cfg->{SITE_DIR};

    my %pathes = ();
    my $http_conf_file = File::Spec->canonpath ($mkdoc_dir . '/conf/httpd.conf');
    
    if (-e $http_conf_file)
    {
	open FP, "<$http_conf_file" || confess "Cannot read-open $http_conf_file: Reason $@";
        %pathes = map { chomp(); $_ => 1 } <FP>;
        close FP;
    }
    
    $pathes{"Include $site_dir/httpd.conf"} = 1;
    open FP, ">$http_conf_file" or confess "Cannot write-open $http_conf_file. Reason: $!";
    print FP join "\n", sort keys %pathes;
    print FP "\n";
    close FP;
}


1;
