# -------------------------------------------------------------------------------------
# MKDoc::Site::Deploy::DB::Schema
# -------------------------------------------------------------------------------------
#
#       Author : Jean-Michel Hiver <jhiver@mkdoc.com>
#                Steve Purkis <spurkis@mkdoc.com>
#    Copyright : Copyright (c) 2001-2002 MKDoc Holdings Ltd.
#
#      Unauthorized modification, use, reuse, distribution or redistribution
#      of this module is stricly forbidden
#
#    Description:
#
#      Database table schemas needed by an MKDoc Site.
#
# -------------------------------------------------------------------------------------

package MKDoc::Site::Deploy::DB::Schema;
use MKDoc::SQL;

sub class
{
    my $class = shift;
    return ref $class || $class;
}


## EDITOR TABLE ##
new MKDoc::SQL::Table
  (
   bless_into => 'flo::Record::Editor',
   name => 'Editor',
   pk   => [ qw /ID/ ],
   ai   => 1,
   cols => [
	    { name => 'ID',          type => new MKDoc::SQL::Type::Int  ( not_null => 1) },
	    { name => 'Login',       type => new MKDoc::SQL::Type::Char ( size => 15, not_null => 1 ) },
	    { name => 'Password',    type => new MKDoc::SQL::Type::Char ( size => 15, not_null => 1 ) },
	    { name => 'Email',       type => new MKDoc::SQL::Type::Char ( size => 255, not_null => 1 ) },
	    { name => 'First_Name',  type => new MKDoc::SQL::Type::Char ( size => 50 ) },
	    { name => 'Family_Name', type => new MKDoc::SQL::Type::Char ( size => 50 ) },
	    { name => 'Disabled',    type => new MKDoc::SQL::Type::Int  ( not_null => 1 ) },
	   ],
   unique => { login_uk => [ qw /Login/ ] },
  );


## DOCUMENT TABLE ##
new MKDoc::SQL::Category
  (
   bless_into => 'flo::Record::Document',
   name => 'Document',
   ai   => 1,
   pk   => [ qw /ID/ ],
   cols => [
	    { name => 'ID',               type => new MKDoc::SQL::Type::Int  ( not_null => 1 ), },
	    { name => 'Parent_ID',        type => new MKDoc::SQL::Type::Int  (), },
	    { name => 'Cache_Control',    type => new MKDoc::SQL::Type::Int  ( not_null => 1 ), },
	    { name => 'Template',         type => new MKDoc::SQL::Type::Char ( not_null => 1, size => 255 ), },
	    { name => 'Description',      type => new MKDoc::SQL::Type::Text ( not_null => 1 ), },
	    { name => 'Keywords',         type => new MKDoc::SQL::Type::Text ( not_null => 1 ), },
	    { name => 'Date_Created',     type => new MKDoc::SQL::Type::DateTime ( not_null => 1 ), },
	    { name => 'Date_Last_Modified',      type => new MKDoc::SQL::Type::DateTime ( not_null => 1 ), },
	    { name => 'Editor_Created_ID',       type => new MKDoc::SQL::Type::Int ( not_null => 1 ), },
	    { name => 'Editor_Last_Modified_ID', type => new MKDoc::SQL::Type::Int ( not_null => 1 ), },
	    { name => 'Name',             type => new MKDoc::SQL::Type::Char ( not_null => 1, size => 50 ), },
	    { name => 'Full_Path',        type => new MKDoc::SQL::Type::Char ( not_null => 1, size => 255 ), },
	    { name => 'Title',            type => new MKDoc::SQL::Type::Char ( not_null => 1, size => 255 ), },
	    { name => 'Lang',             type => new MKDoc::SQL::Type::Char ( not_null => 1, size => 8 ), },
	    { name => 'Rights',           type => new MKDoc::SQL::Type::Text (), },
	    { name => 'Publisher',        type => new MKDoc::SQL::Type::Text (),   },
	    { name => 'Source',           type => new MKDoc::SQL::Type::Text (), },
	    { name => 'Relation',         type => new MKDoc::SQL::Type::Text (), },
	    { name => 'Coverage',         type => new MKDoc::SQL::Type::Text (), },
	    { name => 'Body',             type => new MKDoc::SQL::Type::LongText(), },
	    { name => 'Sibling_Position', type => new MKDoc::SQL::Type::Int  (), },
	    { name => 'Sort_By',          type => new MKDoc::SQL::Type::Char ( size => 50 ), },
	    { name => 'Order_By',         type => new MKDoc::SQL::Type::Int  (), }
	   ],
   unique => { Full_Path_UK => [ qw /Full_Path/ ] },
   index  => { Parent_ID_IDX => [ qw /Parent_ID/ ] },
   '.lang'           => 'en',
   category_path     => 'Full_Path',
   category_id       => 'ID',
   category_name     => 'Name',
   category_parent   => 'Parent_ID',
   category_position => 'Sibling_Position',
   weight => {
	      Keywords    => 10,
	      Description => 8,
	      Title       => 10,
	      Name        => 10,
	      Full_Path   => 5,
	      Lang        => 3,
	      Rights      => 3,
	      Publisher   => 3,
	      Relation    => 3,
	      Coverage    => 3,
	      Body        => 1,
	     },
   fk => {
	  Editor => {
		     Editor_Created_ID       => 'ID',
		     Editor_Last_Modified_ID => 'ID',
		    },
	 },
  );


## BASE_DOCUMENT TABLE ##
new MKDoc::SQL::Table
  (
   name => 'Base_Document',
   pk   => [ qw /ID/ ],
   ai   => 1,
   cols => [
	    { name => 'ID',          type => new MKDoc::SQL::Type::Int ( not_null => 1 ), },
	    { name => 'Editor_ID',   type => new MKDoc::SQL::Type::Int ( not_null => 1 ), },
	    { name => 'Document_ID', type => new MKDoc::SQL::Type::Int ( not_null => 1 ), },
	   ],
   fk => {
	  Document => { Document_ID => 'ID' },
	  Editor   => { Editor_ID   => 'ID' },
	 },
   unique => { Editor_Document_Owner_uk => [ qw /Editor_ID Document_ID/ ], },
  );


## CONTRIBUTOR TABLE ##
new MKDoc::SQL::Table
  (
   bless_into => 'flo::Record::Contributor',
   name => 'Contributor',
   pk   => [ qw /ID/ ],
   ai   => 1,
   cols => [
	    { name => 'ID',          type => new MKDoc::SQL::Type::Int ( not_null => 1 ), },
	    { name => 'Editor_ID',   type => new MKDoc::SQL::Type::Int ( not_null => 1 ), },
	    { name => 'Document_ID', type => new MKDoc::SQL::Type::Int ( not_null => 1 ), },
	   ],
   fk => {
	  Document => { Document_ID => 'ID' },
	  Editor   => { Editor_ID   => 'ID' },
	 },
   unique => { Editor_Document_Contributor_uk => [ qw /Editor_ID Document_ID/ ] },
  );


## DOCUMENT INDEX TABLE ##
new MKDoc::SQL::Table
  (
   name => 'Document_Index',
   pk   => [ qw /ID/ ],
   ai   => 1,
   cols => [
	    { name => 'ID',          type => new MKDoc::SQL::Type::Int  ( not_null => 1 ), },
	    { name => 'Record_ID',   type => new MKDoc::SQL::Type::Int  ( not_null => 1 ), },
	    { name => 'Column_Name', type => new MKDoc::SQL::Type::Char ( not_null => 1, size => 50 ), },
	    { name => 'Keyword',     type => new MKDoc::SQL::Type::Char ( not_null => 1, size => 100 ), }
	   ],
   index  => { DocumentIndex => [ qw /Keyword/ ] },
   fk     => { Document => { Record_ID => 'ID' } },
   unique => { RecordKeywordUK => [ qw /Record_ID Column_Name Keyword/ ] },
  );


## POLL_RESULTS TABLE ##
new MKDoc::SQL::Table
  (
   name => 'Poll_Results',
   pk   => [ qw /ID/ ],
   ai   => 1,
   cols => [
	    { name => 'ID',      type => new MKDoc::SQL::Type::Int  ( not_null => 1 ), },
	    { name => 'Poll_ID', type => new MKDoc::SQL::Type::Char ( size => 100, not_null => 1 ), },
	    { name => 'Answer',  type => new MKDoc::SQL::Type::Char ( size => 100, not_null => 1 ), },
	   ],
  );


## REDIRECT TABLE ##
new MKDoc::SQL::Table
  (
   bless_into => 'flo::Record::Redirect',
   name => 'Redirect',
   pk   => [ qw /ID/ ],
   ai   => 1,
   cols => [
	    { name => 'ID',       type => new MKDoc::SQL::Type::Int  ( not_null => 1 ), },
	    { name => 'Old_Path', type => new MKDoc::SQL::Type::Char ( not_null => 1, size => 255 ), },
	    { name => 'New_Path', type => new MKDoc::SQL::Type::Char ( not_null => 1, size => 255 ), },
	   ],
   unique => { 'Old_New_Uk' => [ qw /Old_Path/ ] },
  );


## SESSION TABLE ##
new MKDoc::SQL::Table
  (
   name => 'Session',
   pk   => [ qw /ID/ ],
   ai   => undef,
   cols => [
	    { name => 'ID',        type => new MKDoc::SQL::Type::Char ( not_null => 1, size => 50 ), },
	    { name => 'Last_Time', type => new MKDoc::SQL::Type::Int  ( not_null => 1 ), },
	    { name => 'IP',        type => new MKDoc::SQL::Type::Char ( size => 20 ), },
	    { name => 'Editor_ID', type => new MKDoc::SQL::Type::Int  ( not_null => 1 ), },
	   ],
   fk => { Editor => { Editor_ID => 'ID' } },
  );


## AUDIENCE TABLE ##
# TODO: deprecate use of 'Value' - use 'Name' instead
new MKDoc::SQL::Table
  (
   bless_into => 'flo::Record::Audience',
   name => 'Audience',
   pk   => [ qw /ID/ ],
   ai   => 1,
   cols => [
	    { name => 'ID',    type => new MKDoc::SQL::Type::Int  ( not_null => 1 ) },
##	    { name => 'Name',  type => new MKDoc::SQL::Type::Char ( size => 255, not_null => 1 ) },
	    { name => 'Value', type => new MKDoc::SQL::Type::Char ( size => 255, not_null => 1 ) },
	    { name => 'Label', type => new MKDoc::SQL::Type::Char ( size => 255, not_null => 1 ) },
	   ],
## unique => { Name_uk => [ qw /Name/ ] },
   unique => { Name_uk => [ qw /Value/ ] },
  );


## DOCUMENT AUDIENCE TABLE ##
new MKDoc::SQL::Table
  (
   bless_into => 'flo::Record::Document_Audience',
   name => 'Document_Audience',
   pk   => [ qw /ID/ ],
   ai   => 1,
   cols => [
	    { name => 'ID',          type => new MKDoc::SQL::Type::Int ( not_null => 1 ) },
	    { name => 'Document_ID', type => new MKDoc::SQL::Type::Int ( not_null => 1 ) },
	    { name => 'Audience_ID', type => new MKDoc::SQL::Type::Int ( not_null => 1 ) },
	   ],
   fk => {
	  Document => { Document_ID => 'ID' },
	  Audience => { Audience_ID => 'ID' },
	 },
  );


## GENERIC PREFERENCE TABLE ##
new MKDoc::SQL::Table
  (
   bless_into => 'flo::Record::Preference',
   name => 'Preference',
   pk   => [ qw /ID/ ],
   ai   => 1,
   cols => [
	    { name => 'ID',        type => new MKDoc::SQL::Type::Int  ( not_null => 1 ) },
	    { name => 'Editor_ID', type => new MKDoc::SQL::Type::Int  ( not_null => 1 ) },
	    { name => 'Name',      type => new MKDoc::SQL::Type::Char ( size => 255, not_null => 1 ) },
	    { name => 'Value',     type => new MKDoc::SQL::Type::Char ( size => 255, not_null => 1 ) },
	   ],
   fk => { Editor => { Editor_ID => 'ID' } },
  );


## AUDIENCE PREFERENCE TABLE ##
new MKDoc::SQL::Table
  (
   bless_into => 'flo::Record::Preference::Audience',
   name => 'Preference_Audience',
   pk   => [ qw /ID/ ],
   ai   => 1,
   cols => [
	    { name => 'ID',          type => new MKDoc::SQL::Type::Int ( not_null => 1 ) },
	    { name => 'Editor_ID',   type => new MKDoc::SQL::Type::Int ( not_null => 1 ) },
	    { name => 'Audience_ID', type => new MKDoc::SQL::Type::Int ( not_null => 1 ) },
	    { name => 'Value',       type => new MKDoc::SQL::Type::Int ( not_null => 1 ) },
	   ],
   fk => {
	  Editor   => { Editor_ID   => 'ID' },
	  Audience => { Audience_ID => 'ID' },
	 },
  );


## LANGUAGE PREFERENCE TABLE ##
new MKDoc::SQL::Table
  (
   bless_into => 'flo::Record::Preference::Language',
   name => 'Preference_Language',
   pk   => [ qw /ID/ ],
   ai   => 1,
   cols => [
	    { name => 'ID',          type => new MKDoc::SQL::Type::Int  ( not_null => 1 ) },
	    { name => 'Editor_ID',   type => new MKDoc::SQL::Type::Int  ( not_null => 1 ) },
	    { name => 'Language_ID', type => new MKDoc::SQL::Type::Char ( size => 25, not_null => 1 ) },
	    { name => 'Value',       type => new MKDoc::SQL::Type::Int  ( not_null => 1 ) },
	   ],
   fk => { Editor => { Editor_ID => 'ID' } },
  );


# TICKETS TABLE #
new MKDoc::SQL::Table
  (
   bless_into => 'flo::Record::Ticket',
   name => 'Tickets',
   pk   => [ qw /ID/ ],
   cols => [
	    { name => 'ID',         type => new MKDoc::SQL::Type::Char     ( size => 25, not_null => 1 ) },
	    { name => 'ExpiryDate', type => new MKDoc::SQL::Type::DateTime ( not_null => 1 ) },
	    { name => 'Email',      type => new MKDoc::SQL::Type::Char     ( size => 255 ) },
	    { name => 'Action',     type => new MKDoc::SQL::Type::Char     ( size => 25 ) },
	   ],
  );


1;

__END__
