#!/usr/bin/perl
use MKDoc::Core;
use MKDoc::Handler::Initialize;
use flo::Standard;
use Data::Dumper;
use strict;
use warnings;

flo::Standard::table ('Document') || MKDoc::Handler::Initialize::handler();

eval { MKDoc::Core->process() };
if (defined $@ and $@)
{
    print "Status: 500 Internal Server Error\n";
    print "Content-Type: text/html; charset=UTF-8\n\n";
    if (ref $@) { $@ = Dumper ($@) }
    $@ = Dumper (\%ENV) . "\n\n" . $@;
    warn "SOFTWARE_ERROR\n\n" . $@ . "\n\n";
}

BEGIN {
    $SIG{'__WARN__'} = sub {
        # trap some common error strings that otherwise flood the error log files
        warn $_[0] unless ($_[0] =~ /byte of utf8 encoded char at/ or
                           $_[0] =~ /is deprecated/                or
                           $_[0] =~ /IMAPClient\.pm line/);
    }
}
