# -------------------------------------------------------------------------------------
# flo::Object
# -------------------------------------------------------------------------------------
#
#       Author : Jean-Michel Hiver (jhiver@cisedi.com).
#    Copyright : (c) MKDoc Holdings Ltd, 2001
# 
#      Unauthorized modification, use, reuse, distribution or redistribution
#      of this module is stricly forbidden.
#
#    Description:
#
#      Base class for all flo::* objects mainly providing a config class method
#
# -------------------------------------------------------------------------------------
package flo::Object;
use MKDoc::Config;
use strict;
use CGI::Carp;


##
# $class->config;
# ---------------
#   Returns the configuration parameters of that class as a
#   hash reference
##
sub config
{
    my $class = shift;
    $class = ref $class || $class;
    
    # compute the config file name from the class name
    my $file = $class;
    $file =~ s/\.pm$//;
    $file =~ s/::/./g;
    
    my $ret = new MKDoc::Config ($file) or
        confess "Cannot find config file $file";
    
    return $ret->hash;
}




1;


