# -------------------------------------------------------------------------------------
# flo::Record::Document_Audience
# -------------------------------------------------------------------------------------
#
#       Author : Jean-Michel Hiver (jhiver@mkdoc.com).
#    Copyright : (c) MKDoc Holdings Ltd, 2002.
#
#       Unauthorized modification, use, reuse, distribution or redistribution
#       of this module is stricly forbidden.
#
#    Description:
#
#       Every record from the 'Document_Audience' table will be blessed into
#       this class so that we can add extra method to access to in the template
#       engine.
#
#    Synopsis:
#
#       use flo::Record::Document_Audience;
#       # not yet
#
# -------------------------------------------------------------------------------------
package flo::Record::Document_Audience;
use flo::Standard qw /table/;
use strict;
use 5.008_000;
use Carp;


##
# $self->id;
# ----------
#   Getter for the 'ID' attribute.
##
sub id
{
    my $self = shift;
    return $self->{ID};
}


##
# $self->set_id ($id);
# --------------------
#   $id - ID of the document to set.
#
#   Setter for the 'ID' attribute.
##
sub set_id
{
    my $self = shift;
    $self->{ID} = shift;
    return $self;
}


##
# $self->document_id;
# -------------------
#   Getter for the 'Document_ID' attribute.
##
sub document_id
{
    my $self = shift;
    return $self->{Document_ID};
}


##
# $self->set_document_id ($document_id);
# --------------------------------------
#   $document_id - The ID of the editor to set.
#
#   Setter for the 'Document_ID' attribute.
##
sub set_document_id
{
    my $self = shift;
    $self->{Document_ID} = shift;
    return $self;
}


##
# $self->document;
# ----------------
#   Returns the Document object which is related to that Contributor record.
##
sub document
{
    my $self = shift;
    my $document_table = table 'Document';
    return $document_table->get ($self->document_id);
}


##
# $self->set_document ($document);
# --------------------------------
#   $document - document object to extract the ID from
#
#   Setter for the 'Document_ID' attribute via the 'flo::Record::Document' object.
##
sub set_document
{
    my $self = shift;
    my $document = shift;
    return $self->set_document_id ($document->id);
}


##
# $self->audience_id;
# -------------------
#   Getter for the 'Audience_ID' attribute.
##
sub audience_id
{
    my $self = shift;
    return $self->{Audience_ID};
}


##
# $self->set_audience_id ($audience_id);
# --------------------------------------
#   $audience_id - The ID of the editor to set.
#
#   Setter for the 'Audience_ID' attribute.
##
sub set_audience_id
{
    my $self = shift;
    $self->{Audience_ID} = shift;
    return $self;
}


##
# $self->audience;
# ----------------
#   Returns the Audience object which is related to that Contributor record.
##
sub audience
{
    my $self = shift;
    my $audience_table = table 'Audience';
    return $audience_table->get ($self->audience_id);
}


##
# $self->set_audience ($audience);
# --------------------------------
#   $audience - audience object to extract the ID from
#
#   Setter for the 'Audience_ID' attribute via the 'flo::Record::Audience' object.
##
sub set_audience
{
    my $self = shift;
    my $audience = shift;
    return $self->set_audience_id ($audience->id);
}


1;


__END__
