# -------------------------------------------------------------------------------------
# flo::editor::Mixin::compute_name
# -------------------------------------------------------------------------------------
#
#       Author : Jean-Michel Hiver (jhiver@mkdoc.com).
#    Copyright : (c) MKDoc Holdings Ltd, 2001
# 
#      Unauthorized modification, use, reuse, distribution or redistribution
#      of this module is stricly forbidden
#
#    Description:
#
#      Mixin to compute random directory names for file attachments, images, etc.
#
# -------------------------------------------------------------------------------------
package flo::editor::Mixin::compute_name;
use strict;


##
# $class->compute_name;
# ---------------------
#   Static method that computes a random 10 digit directory name
##
sub compute_name
{
    my $class = shift;
    my @char = 0..9;
    my $size = scalar (@char);

    return join '', map { $char[int rand $size] } 1..10;
}


1;
