# -------------------------------------------------------------------------------------
# flo::editor::Text
# -------------------------------------------------------------------------------------
# Author : Jean-Michel Hiver <jhiver@mkdoc.com>.
# Copyright : (c) MKDoc Holdings Ltd, 2003
# -------------------------------------------------------------------------------------
package flo::editor::Text;
use flo::Editor;
use flo::Standard;
use MKDoc::CGI;
use MKDoc::XML::Tagger;
use MKDoc::Text::Structured;
use strict;

use flo::Component;
use base qw /flo::Component
	     flo::editor::Mixin::compute_name
	     flo::editor::Mixin::normalize_name/;


sub preferred_extension { 'txt' }


sub new
{
    my $class = shift;
    $class    = ref $class || $class;
    my $self  = bless { @_ }, $class;
    
    my $cgi = $self->{cgi};
    my $param_name = $self->{param_name};
    if (defined $cgi)
    {
	if (defined $cgi->param ($param_name . "_add"))
	{
	    $self->{data} = "";
	}
	else
	{
	    $self->{data} = $cgi->param ($param_name);
	}
    }
    else
    {
	$self->{data} = "";
    }
    
    return $self;
}


sub html
{
    my $self = shift;
    my $data = $self->{'data'};
    $data = MKDoc::Text::Structured::process ($data);
    $data = "<span>$data</span>";
    
    my @link = flo::Editor->links();
    my @newl = ();
    for (@link) {
        my $new = { %{$_} };
        $new->{_expr} = delete $new->{expr};
        $new->{_tag}  = 'a';
        $new->{title} = delete $new->{desc};
        push @newl, $new;
    }

    return MKDoc::XML::Tagger->process_data ($data, @newl);
}


sub parse_xml
{
    my $self = shift;
    my $data = shift;
    $data !~ /^<perl/ and $data !~ /^<hash/ and do {
	$self->{data} = $data;
	$self->{data} =~ s/\&lt\;/</g;
	$self->{data} =~ s/\&gt\;/>/g;
	$self->{data} =~ s/\&amp\;/&/g;
	$self->{data} =~ s/\&quot\;/\"/g;
        return $self;
    };

    $self->SUPER::parse_xml ($data, @_);
}


sub as_xhtml { return "<div>" . shift()->html() . "</div>" }


1;
