# -------------------------------------------------------------------------------------
# flo::plugin::Admin::Component::Move
# -------------------------------------------------------------------------------------
# Author : Jean-Michel Hiver <jhiver@mkdoc.com>
# Copyright : (c) MKDoc Holdings Ltd, 2003
#
# Lets an editor delete the current document. Redirects to the parent document.
# -------------------------------------------------------------------------------------
package flo::plugin::Admin::Component::Move;
use MKDoc::Config;
use MKDoc::Error;
use flo::Standard;
use Encode;
use strict;
use warnings;
use 5.008_000;
use Carp;


use base qw /flo::plugin::Admin::Component::Copy/;


sub template_path { 'admin/component_move' }


sub uri
{
    my $self = shift;
    my $uri  = $self->SUPER::uri();
    $uri .= ',move';
    return $uri;
}


##
# $self->activate;
# ----------------
# Returns TRUE if this plugin can be activated, FALSE
# otherwise.
##
sub activate
{
    my $self = shift;
    return unless ($self->flo::ComponentPlugin::activate (@_));
    
    my $current_document = flo::Standard::current_document();
    return unless $current_document->Can_Admin;
    
    my $cgi = flo::Standard::cgi();
    my $path_info = $cgi->path_info;
    $path_info =~ /,move$/ || return;
    
    return 1;
}


sub _validate_defined
{
    my $self = shift;
    my $to = shift;
    defined $to and $to or do {
	new MKDoc::Ouch 'document/move/no_target';
	return 0;
    };
    return 1;
}


sub _validate_exists
{
    my $self = shift;
    my $to   = shift;
    my $document_t = flo::Standard::table ('Document');
    $document_t->get ($to) or do {
	new MKDoc::Ouch 'document/move/no_target';
	return 0;
    };
    return 1;
}


sub _validate_perms
{
    my $self = shift;
    my $to   = shift;
    my $document_t = flo::Standard::table ('Document');
    my $doc  = $document_t->get ($to);
    $doc->Can_Admin() or do {
	new MKDoc::Ouch 'document/move/denied';
	return 0;
    };
    return 1;
}


sub redirect
{    
    my $self = shift;
    my $cgix = flo::Standard::cgi()->new();

    my $to         = $cgix->param ('to');
    my $document_t = flo::Standard::table ('Document');
    my $new_parent = $document_t->get ($to);
    
    $cgix->path_info ($new_parent->path());
    $cgix->delete ($cgix->param());
    print $cgix->redirect ($cgix->self_url);
}


sub http_post
{
    my $self  = shift;
    my $cgix  = flo::Standard::cgi()->new();
    my $to    = $cgix->param ('to');
    my $cmp   = $self->component();
    
    $self->_validate_defined ($to) || return $self->http_get();
    $self->_validate_exists  ($to) || return $self->http_get();
    $self->_validate_perms   ($to) || return $self->http_get();
    
    my $document_t = flo::Standard::table ('Document');
    my $new_parent = $document_t->get ($to);
    $cmp->move_to ($new_parent);
    
    $self->has_errors() and return $self->http_get();
    $self->redirect ($new_parent);
    return 'TERMINATE';
}


1;
