# -------------------------------------------------------------------------------------
# flo::plugin::Admin::Restore
# -------------------------------------------------------------------------------------
#
#       Author : Jean-Michel Hiver <jhiver@mkdoc.com>
#    Copyright : (c) MKDoc Holdings Ltd, 2002
#
#      Unauthorized modification, use, reuse, distribution or redistribution
#      of this module is stricly forbidden
#
#    Description:
#
#      Clobbers parent document.
# -------------------------------------------------------------------------------------
package flo::plugin::Admin::Restore;
use flo::RedirectManager;
use MKDoc::Config;
use MKDoc::Error;
use flo::Standard;
use flo::plugin::Admin::Content;
use flo::Editor;
use strict;
use warnings;
use 5.008_000;
use Carp;

use base qw /flo::Plugin/;


sub http_get { return }


##
# $self->http_post;
# -----------------
#   Reflect the changes on the database and redirects to
#   current document.
##
sub http_post
{
    my $self = shift;
    my $cgix = flo::Standard::cgi()->new;
    my $current_document = flo::Standard::current_document();

    my $parent = $current_document->parent() || return;
    $parent->set_cache_control           ($current_document->cache_control());
    $parent->set_template                ($current_document->template());
    $parent->set_description             ($current_document->description());
    $parent->set_keywords                ($current_document->keywords());
    $parent->set_date_created            ($current_document->date_created());
    $parent->set_date_last_modified      ($current_document->date_last_modified());
    $parent->set_editor_created_id       ($current_document->editor_created_id());
    $parent->set_editor_last_modified_id ($current_document->editor_last_modified_id());
    $parent->set_title                   ($current_document->title());
    $parent->set_lang                    ($current_document->lang());
    $parent->set_rights                  ($current_document->rights());
    $parent->set_publisher               ($current_document->publisher());
    $parent->set_relation                ($current_document->relation());
    $parent->{Body} = $current_document->{Body};
    $parent->save();

    print $cgix->redirect ($parent->uri());
    return 'TERMINATE';
}


1;
