package flo::plugin::Admin::UserInsert;
use strict;
use warnings;
use flo::Standard;
use flo::Record::Editor;
use base qw /flo::Plugin/;


sub activate
{
    my $self = shift;
    $self->SUPER::activate (@_) || return;
    $self->user()->id() == 1    || return;
    return 1;
}


sub template_path { 'admin/user_insert' }


sub http_get
{
    my $self = shift;
    $self->render_http (
	self => $self,
	__output__ => 'XHTML',
       );
    
    return 'TERMINATE';
}


sub http_post
{
    my $self = shift;
    my $cgi  = flo::Standard::cgi();
    my $user = new flo::Record::Editor (
	Login       => $cgi->param ('login'),
	Password    => $cgi->param ('password'),
	Email       => $cgi->param ('email'),
	First_Name  => $cgi->param ('first_name'),
	Family_Name => $cgi->param ('family_name'),
	Disabled    => $cgi->param ('disabled'),
       );
    
    $self->has_errors() and return $self->http_get();
    $self->insert_base_document ($user->id());
    
    $self->{ok} = 1;
    $cgi->delete ($cgi->param());
    return $self->http_get();
}


sub insert_base_document
{
    my $self = shift;
    my $id = shift;
    my $cgi = flo::Standard::cgi();
    my @base_documents = map { 0 + $_ > 0 ? $_ : () } $cgi->param ('base_documents');
    
    my $base_document_t = flo::Standard::table ('Base_Document');
    $base_document_t->delete (Editor_ID => $id);
    $base_document_t->insert (Editor_ID => $id, Document_ID => $_) for (@base_documents);
}


sub documents
{
    my $self = shift;
    my $document_t = flo::Standard::table ('Document');
    my @res = $document_t->select (
	cols => '*',
	sort => [ 'Full_Path' ],
	desc => 0,
       )->fetch_all();

    return wantarray ? @res : \@res;
}


sub is_selected
{
    my $self = shift;
    my $document = shift;
    my $id = $document->id();
    my $cgi = flo::Standard::cgi();
    my @base_documents = $cgi->param ('base_documents');
    $_ == $id and return 1 for (@base_documents);
    return;
}


1;
