# -------------------------------------------------------------------
# flo::plugin::Cache::Fake
# -------------------------------------------------------------------
# Author: Jean-Michel Hiver <jhiver@mkdoc.com>
# Copyright: (c) MKDoc Holdings Ltd, 2003
# Description: flo::plugin::Cache::Fake sends the data
# that the current document outputs without caching it.
# -------------------------------------------------------------------
package flo::plugin::Cache::Fake;
use strict;
use warnings;
use Encode;
use Carp;
use flo::Standard;
use flo::HTTP::Header;
use 5.008_000;

use base qw /flo::DocumentPlugin/;


sub name { '' }

sub main
{
    my $class = shift;
    return $class->SUPER::main (@_);
}

sub activate
{
    my $self = shift;
    flo::Standard::raw_path_info =~ /\./  and return;
    flo::Standard::raw_path_info =~ /\/$/  || return;
    $self->document()                      || return;
    return 1;
}


# deprecated
sub mode
{
    my $self = shift;
    my $mode = 'admin';
    return $mode;
}


# deprecated
sub is_mode
{
    my $self = shift;
    my $mode = shift;
    return $mode eq $self->mode;
}


sub template_path
{
    my $self = shift;
    return 'document/' . $self->template();
}


sub run
{
    my $self = shift;
    $self->render_http (
        self       => $self,
	__input__  => 'XML',
	__output__ => 'XHTML'
       );
    
    return 'TERMINATE';
}


1;
