# -------------------------------------------------------------------------------------
# flo::plugin::DC
# -------------------------------------------------------------------------------------
# Author : Jean-Michel Hiver <jhiver@mkdoc.com>.
# Copyright : (c) MKDoc Holdings Ltd, 2003.
#
# This plugin outputs RDF dublin core metadata for the current document
# -------------------------------------------------------------------------------------
package flo::plugin::DC;
use flo::Standard;
use strict;
use base qw /flo::Plugin/;

sub _name_default { '.meta.rdf' }

sub run
{
    my $self = shift;
    $self->render_http (
	self       => $self,
	object     => flo::Standard::current_document,
	__input__  => 'XML',
	__output__ => 'XHTML',
       );
    
    return 'TERMINATE';
}

sub content_type  { 'application/xml'       }

sub template_path { '/metadata/dcq.rdf.xml' }


1;


__END__
