# -------------------------------------------------------------------------------------
# flo::plugin::Headlines
# -------------------------------------------------------------------------------------
# Author : Chris Croome <chris@mkdoc.com>, Jean-Michel Hiver <jhiver@mkdoc.com>
# Copyright : (c) MKDoc Holdings Ltd, 2003
# -------------------------------------------------------------------------------------
package flo::plugin::Headlines;
use strict;
use flo::Standard;
use MKDoc::Util::Text2HTML;
use XML::RSS;


use base qw /flo::Plugin/;


sub content_type { 'application/xml' }

sub _name_default { '.headlines.rss' }


sub http_get
{
    my $self = shift;
    $self->render_http();
    return 'TERMINATE';
}


sub limit
{
    my $res = do {
	no warnings;
	0 + flo::Standard::cgi->param ('limit');
    };
    $res > 0 ? $res : 8;
}


sub render
{
    my $self = shift;
    my $rss  = new XML::RSS (version => '1.0');
    $rss->channel ($self->channel());
    for ($self->items()) { $rss->add_item (%{$_}) }
    
    return $rss->as_string();
}


sub channel
{
    my $self = shift;
    my $doc  = flo::Standard::current_document();
    return (
	title       => text2xml ( $doc->title() ),
	link        => text2xml ( $doc->uri() ),
	description => text2xml ( $doc->description() ),
	dc => {
	    date       => $doc->date_created_w3c(),
	    subject    => text2xml ( $doc->keywords() ),
	    creator    => text2xml ( $doc->editor_created()->real_name() ),
	    publisher  => text2xml ( $doc->publisher() ),
	    rights     => text2xml ( $doc->rights() ),
	    language   => text2xml ( $doc->lang() ),
	},
	syn => {
	    updatePeriod     => "daily", # values: hourly, daily, weekly, monthly, yearly
	    updateFrequency  => "1",
	    updateBase       => "2001-04-13T12:00Z",
	},
       );
}


sub items
{
    my $self = shift;
    
    use MKDoc::SQL::Condition;
    my $cond = new MKDoc::SQL::Condition;
    my $doc  = flo::Standard::current_document();
    $cond->add ('Full_Path', 'LIKE', $doc->path() . '_%');
    
    my $document_t = flo::Standard::table ('Document');
    my $query = $document_t->select (
	cols   => '*',
	sort   => [ 'Date_Created' ],
	desc   => 1,
	# page   => [ 1, $self->limit() ],
	where  => $cond,
       );
    
    my @res = map { $_->is_showable() ? $_ : () } $query->fetch_all();
    @res    = splice @res, 0, $self->limit();
    @res    = map { $self->item ($_) } @res;
    return wantarray ? @res : \@res;
}


sub item
{
    my $self = shift;
    my $doc  = shift;
    
    my $res  = {
        title       => text2xml ( $doc->title() ),
	link        => text2xml ( $doc->uri() ),
	description => text2xml ( $doc->description() ),
	dc => {
	    subject    => text2xml ( $doc->keywords() ), 
	    date       => $doc->date_created_w3c(), 
	    publisher  => text2xml ($doc->rights()),
	    rights     => text2xml ($doc->rights()),
	    language   => text2xml ($doc->lang()),
	    creator    => text2xml ($doc->editor_created()->real_name()),
	},
    };
}


1;
