# -------------------------------------------------------------------
# flo::plugin::Logout
# -------------------------------------------------------------------
# Author: Jean-Michel Hiver <jhiver@mkdoc.com>
# Copyright: (c) MKDoc Holdings Ltd, 2003
# Description: flo::plugin::Logout sends the data
# that the current document outputs without caching it.
# -------------------------------------------------------------------
package flo::plugin::Logout;
use strict;
use warnings;
use flo::Standard;
use base qw /flo::Plugin/;


sub activate
{
    my $self = shift;
    return unless defined $ENV{REMOTE_USER};
    return $self->SUPER::activate (@_);
}


sub run
{
    my $self = shift;
    
    my $cgi  = flo::Standard::cgi();
    $cgi->path_info ('/');

    for ($cgi->param()) { $cgi->delete ($_) }    
    $cgi->param ('logout', time + 10);
    
    print $cgi->redirect ($cgi->self_url);
    return 'TERMINATE';
}


1;
