# -------------------------------------------------------------------------------------
# flo::plugin::Photo
# -------------------------------------------------------------------------------------
# Author : Jean-Michel Hiver <jhiver@mkdoc.com>
# Copyright : (c) MKDoc Holdings Ltd, 2003
# Description : Served photo small, scaled, full and html versions
# -------------------------------------------------------------------------------------
package flo::plugin::Photo;
use MKDoc::Config;
use strict;
use warnings;
use 5.008_000;
use Carp;

use base qw /flo::ComponentPlugin/;

use constant MODE_SMALL  => 1;
use constant MODE_SCALED => 2;
use constant MODE_HTML   => 3;
use constant MODE_FULL   => 4;


sub run
{
    my $self = shift;
    my $mode = $self->mode();
    $mode == MODE_SMALL  and return $self->_run_small();
    $mode == MODE_SCALED and return $self->_run_scaled();
    $mode == MODE_HTML   and return $self->_run_html();
    $mode == MODE_FULL   and return $self->_run_full();
}


sub _run_full
{
    my $self = shift;
    my $component = $self->component();
    my $location  = $component->internal_location();
    
    if ($ENV{MOD_PERL})
    {
	my $r = Apache->request;
	$r->internal_redirect ($location);
    }
    else
    {
	my $cgi = flo::Standard::cgi();
	$cgi->path_info ($location);
	print $cgi->redirect ($cgi->self_url);
    }
    
    return 'TERMINATE';
}


sub _run_scaled
{
    my $self = shift;
    my $component = $self->component();
    my $location  = $component->internal_location_scaled();
    
    if ($ENV{MOD_PERL})
    {
	my $r = Apache->request;
	$r->internal_redirect ($location);
    }
    else
    {
	my $cgi = flo::Standard::cgi();
	$cgi->path_info ($location);
	print $cgi->redirect ($cgi->self_url);
    }
    
    return 'TERMINATE';
}


sub _run_small
{
    my $self = shift;
    my $component = $self->component();
    my $location  = $component->internal_location_small();
    
    if ($ENV{MOD_PERL})
    {
	my $r = Apache->request;
	$r->internal_redirect ($location);
    }
    else
    {
	my $cgi = flo::Standard::cgi();
	$cgi->path_info ($location);
	print $cgi->redirect ($cgi->self_url);
    }
    
    return 'TERMINATE';
}


sub template_path { 'photo' }


sub _run_html
{
    my $self = shift;
    $self->render_http (
	self       => $self,
	object     => flo::Standard::current_document(),
	__input__  => 'XML',
	__output__ => 'XHTML',
       );
    
    return 'TERMINATE';    
}


sub activate
{
    my $self = shift;
    $self->SUPER::activate() || return;
    
    my $component = $self->component;
    $component->isa ('flo::editor::Photo') || return;
    
    return 1;
}


sub mode
{
    my $self = shift;
    my $cgi = flo::Standard::cgi();
    my $path_info = $cgi->path_info;
    
    my $small = MKDoc::Config->PHOTO_SMALL_HINT;
    $path_info =~ /,$small$/  and return MODE_SMALL;
    
    my $scaled = MKDoc::Config->PHOTO_SCALED_HINT;
    $path_info =~ /,html$/    and return MODE_HTML;
    $path_info =~ /,$scaled$/ and return MODE_SCALED;
    
    return MODE_FULL;
}


sub prev
{
    my $self = shift;
    $self->_prev_next();
    return $self->{_prev};
}


sub next
{
    my $self = shift;
    $self->_prev_next();
    return $self->{_next};
}


sub _prev_next
{
    my $self = shift;
    $self->{_prev_next_done} ||= do {
	my $self_component = $self->component();
	my $editor = flo::Editor::_ETERNAL_();
	my @photos = flo::Standard::current_document()->components ('photo');
	@photos = map { (defined $_->{image} and $_->{image}) ? $_ : () } @photos;
	
	my ($photo, $photo_prev, $photo_next);
	for (my $i=0; $i < @photos; $i++)
	{
	    $photo = $photos[$i];
	    $photo_prev = ($i == 0) ? undef : $photos[$i-1];
	    $photo_next = ($i == @photos) ? undef : $photos[$i+1];
	    last if ($photo->equals ($self_component));
	}
	$self->{_prev} = $photo_prev;
	$self->{_next} = $photo_next;
	1;
    };
}



1;


__END__
