# -------------------------------------------------------------------------------------
# flo::plugin::Robots
# -------------------------------------------------------------------------------------
#
#       Author : Alexandre Girard (agirard@popmail.com)
#    Copyright : (c) MKDoc Holdings Ltd, 2001
# 
#      Unauthorized modification, use, reuse, distribution or redistribution
#      of this module is stricly forbidden
#
#    Description:
#
#      A plugin that is used to avoid search engine browsing sitemap and
#      search engine
#
# -------------------------------------------------------------------------------------
package flo::plugin::Robots;
use flo::Standard;
use base qw /flo::Plugin/;
use warnings;
use strict;

our @FORBIDDEN = ();


sub register
{
    my $class = shift;
    my $stuff = shift;
    push @FORBIDDEN, $stuff->name();
}


sub name { 'robots.txt' }


sub http_get
{
    ($ENV{REQUEST_METHOD} =~ /^GET$/) and do {
	print "Content-Type: text/plain; charset=US-ASCII\n\n";
	return 'TERMINATE';
    };
    
    my $sql = 'SELECT Full_Path FROM Document';
    my $dbh = MKDoc::SQL::DBH->get;
    my $sth = $dbh->prepare_cached ($sql);
    $sth->execute();
    
    print "User-agent: *\n";
    while (my $arryref = $sth->fetchrow_arrayref)
    {
	print $arryref->[0] . $_ . "\n" for (@FORBIDDEN);
    }
    
    return 'TERMINATE';
}


1;


__END__
