#!/usr/bin/perl
use strict;
use warnings;
use MKDoc::Init::DBI;
use flo::Standard;

MKDoc::Init::DBI->init;

main();

sub main
{
    my $document_t = flo::Standard::table ('Document');
    my $redirect_t = flo::Standard::table ('Redirect');

    my $from = shift (@ARGV) or croak "Usage: $0 <from> <to>";
    my $to   = shift (@ARGV) or croak "Usage: $0 <from> <to>";
    
    # check that $from is correct
    $from ne '/' or croak "Cannot move MKDoc's root document";
    my $from_document = $document_t->get ( Full_Path => $from ) or croak "Cannot get document with path $from";
    
    # check that $to is correct
    my $to_document = $document_t->get ( Full_Path => $to ) or croak "Cannot get document with path $to";
    
    # make sure that $to_document has no child document with the same name
    my @children = $to_document->children;
    $_->name() eq $from_document->name() and croak "$to has a children with the name " . $_->name() for (@children);
    
    # everything's OK, let's do the move
    $from_document->set_parent ($to_document);
    $document_t->modify ($from_document);
    $redirect_t->delete ( Old_Path => $from_document->path() );
    $redirect_t->insert ( Old_Path => $from, New_Path => $from_document->path() );
}


1;
