# -------------------------------------------------------------------------------------
# MKDoc::Handler::Authenticate
# -------------------------------------------------------------------------------------
# Author: Jean-Michel Hiver (jhiver@mkdoc.com).
# Copyright: (c) MKDoc Holdings Ltd, 2003
# Description: Authenticates against MKDoc's 'Editor' table
# -------------------------------------------------------------------------------------
package MKDoc::Handler::Authenticate;
use strict;
use warnings;
use Carp;
use flo::Standard;
use flo::Record::Editor;
use Apache::Constants qw/:common/;
use strict;
use Carp;


sub get_login
{
    my $r = Apache->request();
    my %args = $r->args();
    return $r->connection->user() || ''; 
}


sub get_password
{
    my $r = Apache->request();
    my ($res, $sent_pw) = $r->get_basic_auth_pw;
    my %args = $r->args();
    return $sent_pw || ''; 
}


sub is_logout
{
    my $login = uc (shift);
    $login    =~ s/[^0-9A-Z-]//g;
    $login  ||= 'default';

    my $file  = '/tmp/MKD-AUTH__' . $login . '@' . Apache->request()->hostname();
    -e $file or return;
    -f $file or return;

    my @stat = stat ($file);
    my $stat = $stat[9];
    time - $stat <= 7 and return 1;

    unlink ($file);
    return; 
}


sub handler
{
    my $r = shift;
    $::MKD_USER = undef;

    # checks that the user has sent a login / password pair
    my ($res, $sent_pw) = $r->get_basic_auth_pw;
    if ($res != OK)
    {
        $::MKD_USER = undef;
        return $res;
    }
    
    $sent_pw  = get_password(); 
    my $login = get_login(); 

    unless ($login and $sent_pw)
    {
        $r->note_basic_auth_failure;
        $r->log_reason ("Both username and passwords must be provided, ", $r->filename);
        $::MKD_USER = undef;
        return AUTH_REQUIRED;
    }
   
    # fetches the user's password
    my $editor_t = flo::Standard::table ('Editor');
    my $editor   = $editor_t->get (Login => $login) || do {
        $r->note_basic_auth_failure;
        return AUTH_REQUIRED;
    };
    
    # if the user is disabled ========> []
    unless ($editor->is_enabled())
    {
        $::MKD_USER = undef;
        $r->note_basic_auth_failure;
        return AUTH_REQUIRED;
    }
    
    is_logout ($login) and do {
        $r->note_basic_auth_failure;
        return AUTH_REQUIRED;
    };

    # compares the real password with the provided password
    if ($editor->password() eq $sent_pw)
    {
        $::MKD_USER = $editor;
        return OK;
    }
    else
    {
        $::MKD_USER = undef;
        $r->note_basic_auth_failure;
        return AUTH_REQUIRED;
    }
}


1;


__END__
