# -------------------------------------------------------------------------------------
# MKDoc::Handler::Initialize
# -------------------------------------------------------------------------------------
# Author: Jean-Michel Hiver <jhiver@mkdoc.com>.
# Copyright: (c) MKDoc Holdings Ltd, 2001
# Description: Initializes MKDoc framework for subsequent handlers.
# -------------------------------------------------------------------------------------
package MKDoc::Handler::Initialize;
use Petal;
use MKDoc::Config;
use strict;
use warnings;
use Carp;

use flo::Standard;
use lib::sql::DBH;
use CGI qw(-compile :all);


sub sillyness
{
    $::MKD_IS_INIT,
    $::P_MKD_IMP
}


# this will be executed once per-process, and initializes
# configuration that is not site-specific.
sub _do_once
{
    $::P_MKD_DIR = MKDoc::Config::get_env ('MKDOC_DIR') || confess 'MKDOC_DIR is not defined';
    $::P_MKD_IMP = {};
    
    # add MKDOC_DIR to libs unless it already is
    unshift (@INC, $::P_MKD_DIR) unless (grep /^\Q$::P_MKD_DIR\E$/, @INC);
    
    $::MKD_IS_INIT_ONCE = 1;
}


sub handler
{
    _do_once() unless ($::MKD_IS_INIT_ONCE);
    
    $CGI::USE_PARAM_SEMICOLONS = 1;
    + lib::sql::DBH->disconnect;
    
    clean_globals();
    clean_more_globals();

    $Petal::DECODE_CHARSET = 'utf8';
    $Petal::ENCODE_CHARSET = 'utf8';    
    $Petal::BASE_DIR = undef;
    @Petal::BASE_DIR = (MKDoc::Config->TEMPLATE_DIR2, map { "$_/templates" } @INC);
    
    # loads database table schemas
    + lib::sql::Table->load_state (MKDoc::Config->SITE_DIR .'/su');
    
    # sets up the document table to the current document language,
    # provided that we're on some kind of document
    # my $document_table = flo::Standard::table ('Document');
    # $document_table->lang (undef);
    # my $current_document = flo::Standard::current_document();
    # (defined $current_document) and $document_table->lang ($current_document->lang);
    
    $::MKD_IS_INIT = 1;
    return 1;
}


# reinitializes global variables to their default values
sub clean_more_globals
{
    $lib::PSP::BASE_DIR         = undef;
    $lib::PSP::BASE_DIR         = undef;
}


# reinitializes global variables to their default values
sub clean_globals
{
    foreach my $key (keys %::)
    {
	if ($key =~ /^MKD_/)
	{
	    my $val = $ {$::{$key}};
	    next unless (defined $val);            # already reinitialized...
	    next if (ref $val eq 'MKDoc::Config'); # handled by process()
	    
	    # if $val is a hashref, then reinitialize
	    # to an empty hashref
	    if (ref $val eq 'HASH')
	    {
		$ {$::{$key}} = {};
		next;
	    }
	    
	    # if $val if an arrayref, then reinitialize
	    # to an empty arrayref
	    if (ref $val eq 'ARRAY')
	    {
		$ {$::{$key}} = [];
		next;
	    }
	    
	    # otherwise, just undef the variable
	    $ {$::{$key}} = undef;
	}
    }
}


1;


__END__
