# -------------------------------------------------------------------------------------
# MKDoc::Util::Date
# -------------------------------------------------------------------------------------
# Author : Jean-Michel Hiver <jhiver@mkdoc.com>.
# Copyright : (c) MKDoc Holdings Ltd, 2003
#
# Returns a date in the right language / character set.
# (Actually, doesn't. This needs to be reimplemented)
# -------------------------------------------------------------------------------------
package MKDoc::Util::Date;
use Unicode::String qw /utf8 latin1/;
use MKDoc::XML::Dumper;
use strict;
use utf8;
use 5.008_000;


##
# $class->new ($time);
# --------------------
#   $time - The time as given by the time() function. This argument
#   is optional, if it's not provided the constructor will use the
#   result of build in time() function.
#
#   Instanciates a new MKDoc::Date object.
##
sub new
{
    my $class = shift;
    $class = ref $class || $class;
    
    my $self = bless { time => shift || time }, $class;
    return $self;
}


##
# $self->time;
# ------------
#   Returns the current Date 'time' in seconds since the epoch
##
sub time
{
    my $self = shift;
    return $self->{time};
}


##
# $self->set_time ($time);
# ------------------------
#   $time - The time as given by the time() function.
#
#   Sets the current Date 'time' in seconds since the epoch
##
sub set_time($)
{
    my $self = shift;
    $self->{time} = shift; # u_shift
}


##
# $self->filter ($template, $iso_lang);
# -------------------------------------
#   $template - A string template.
#   $iso_lang - Language code for the language to use for that date.
#
#   Processes and returns this date depending on what's in $template.
#   Acceptable tags are:
#
#   <AM_PM> <SEC> <MIN> <HOUR_24> <HOUR_24_PADDED> <HOUR_12>
#   <HOUR_12_PADDED> <MDAY> <MON> <MON_LANG> <MON_LANG_ABBR>
#   <YEAR> <WDAY> <WDAY_LANG> <WDAY_LANG_ABBR> <YDAY> <ISDST>
##
sub filter
{
    my $self = shift;
    my $tmpl = shift; # u_shift
    my $lang = shift; # u_shift
    # my $ref_lang = local_language_ressource ('i18n/date', $lang);
    
    my $time = $self->time;
    my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime ($time);
    $year += 1900;
    my $am_pm = ($hour > 12) ? 'pm' : 'am';
    
    my $hour_padded = $hour;
    $hour_padded = '0' . $hour if (length ($hour) == 1);
    
    my $hour_12 = ($hour > 12) ? ($hour - 12) : $hour;
    my $hour_12_padded = $hour_12;
    $hour_12_padded = '0' . $hour_12_padded if (length ($hour_12) == 1);
    
    my $hash = {
	AM_PM          => $am_pm,
	SEC            => $sec,
	MIN            => $min,
	HOUR_24        => $hour,
	HOUR_24_PADDED => $hour_padded,
	HOUR_12        => $hour_12,
	HOUR_12_PADDED => $hour_12_padded,
	MDAY           => $mday,
	# MDAY           => ($lang =~ /^en/) ? $ref_lang->{day_abbr}->[$mday] : $mday, # patricka
	MON            => (length ($mon) > 1) ? $mon + 1 : '0' . ($mon + 1),
	MON_LANG       => $mon, # $ref_lang->{mon}->[$mon],
	MON_LANG_ABBR  => $mon, # $ref_lang->{mon_abbr}->[$mon],
	YEAR           => $year,
	WDAY           => $wday,
	# WDAY_LANG      => $ref_lang->{wday}->[$wday],
	# WDAY_LANG_ABBR => $ref_lang->{wday_abbr}->[$wday],
	YDAY           => $yday,
	ISDST          => $isdst,
    };
    
    my %tags = map { $_ => 1 } $tmpl =~ /<(.+?)>/g;
    my @tags = keys %tags;
    foreach my $tag (@tags)
    {
	my $val = $hash->{$tag} || next;
	$tag = quotemeta ('<' . $tag . '>');
	$tmpl =~ s/$tag/$val/g;
    }
    
    return $tmpl;
}


1;
