# -------------------------------------------------------------------------------------
# MKDoc::Util::Site_List
# -------------------------------------------------------------------------------------
# Author : Jean-Michel Hiver (jhiver@mkdoc.com).
# Copyright : (c) MKDoc Holdings Ltd, 2003
#
# Simple module which can be used to return every MKDoc registered site.
# -------------------------------------------------------------------------------------
package MKDoc::Util::Site_List;
use strict;
use warnings;


sub site_list
{
    my $file = $ENV{MKDOC_DIR} . '/conf/httpd.conf';
    my @res  = ();
    open FP, "<$file" || die "Cannot read-open $file!";
    while (<FP>)
    {
	chomp();
        s/^Include\s+//    || next;
        s/\/httpd\.conf.*// || next;
        push @res, $_;
    }
    close FP;
    
    return sort @res;
}


1;


__END__
