# -------------------------------------------------------------------------------------
# flo::HTTP::Header
# -------------------------------------------------------------------------------------
#
#       Author : Jean-Michel Hiver (jhiver@mkdoc.com).
#    Copyright : (c) MKDoc Holdings Ltd, 2001
# -------------------------------------------------------------------------------------
package flo::HTTP::Header;
use flo::Standard;
use strict;
use utf8;
use 5.008_000;


# $::MKD_flo_HTTP_Header_ETERNAL;
# -------------------------------
#   This variable is 'semi-eternal', as it is automatically
#   reinitialized on each request.
$::MKD_flo_HTTP_Header_ETERNAL = undef;


# _ETERNAL_;
# ----------
#   Function which returns the 'semi-eternal' flo::HTTP::Header
#   singleton.
sub _ETERNAL_()      { return $::MKD_flo_HTTP_Header_ETERNAL  }


# _ETERNAL_;
# ----------
#   Function which sets the 'semi-eternal' flo::HTTP::Header
#   singleton.
sub _SET_ETERNAL_($) { $::MKD_flo_HTTP_Header_ETERNAL = shift }


##
# $class->new;
# ------------
#   Constructs a new flo::HTTP::Header. This should be done once
#   per query, other bits of code accessing the object via
#   flo::HTTP::Header::Accessor.
#
#   This method will return the 'semi eternal' singleton if it
#   exists, or create it and return the newly created object
#   otherwise
##
sub new
{
    return _ETERNAL_ if (defined _ETERNAL_);
    my $class = shift;
    $class = ref $class || $class;
    _SET_ETERNAL_ (bless { @_ }, $class);
    return _ETERNAL_;
}


##
# $self->set ($name, $value);
# ---------------------------
#   i.e. $self->set ('Content-Type', 'text/plain');
##
sub set
{
    my $self = shift;
    my $line = shift; # u_shift
    my ($key, $val) = $line =~ /^\s*(.*?)\s*:\s*(.*?)\s*$/;
    if (defined $key and defined $val) { $self->{$key} = $val }
}


##
# $self->header;
# --------------
#   Returns the HTTP headers string representing that flo::HTTP::Header object
##
sub header
{
    my $self = shift;
    return (join "\n", map { $_ . ": " . $self->{$_} } sort keys %{$self}) . "\n\n";
}


1;
