# -------------------------------------------------------------------------------------
# flo::Record::Preference::Audience
# -------------------------------------------------------------------------------------
#
#       Author : Steve Purkis <spurkis@mkdoc.com>
#    Copyright : (c) MKDoc Holdings Ltd, 2002.
#      Version : $Id: Audience.pm,v 1.2 2002/09/17 17:23:48 spurkis Exp $
#
#       Unauthorized modification, use, reuse, distribution or redistribution
#       of this module is stricly forbidden.
#
#    Description:
#
#       Every record from the 'Preference_Audience' table will be blessed into
#       this class.  This class adds Audience checking to Preference objects
#       using flo::Record::Audience.
#
#    Synopsis:
#
#       use flo::Record::Preference::Audience qw/LIKE DONT_MIND HATE/;
#
#       # create + save new language pref:
#       my $pref = new flo::Record::Preference::Audience;
#       $pref->set_editor($editor)
#            ->set('en', LIKE)
#            ->save;
#
#       # load existing language pref:
#       my $pref   = load flo::Record::Preference::Audience( ID => $id );
#       my $editor = $pref->editor;
#
#       # load editor's language prefs:
#       my @prefs  = load flo::Record::Preference::Audience( Editor => $editor );
#
#       # delete existing language pref:
#       $pref->delete;
#
# -------------------------------------------------------------------------------------

package flo::Record::Preference::Audience;

use flo::Record::Preference qw/ LIKE DONT_MIND HATE /;
use flo::Record::Audience;
use flo::Standard qw/ table /;

use Exporter;
use strict;
use 5.008_000;


##
# INHERITS FROM
# =============
#
# Exporter, flo::Record::Preference
##

use base qw/ Exporter flo::Record::Preference /;


##
# CLASS VARIABLES
# ===============
##

## Version (from CVS revision string).
our $VERSION = (split(/ /, '$Revision: 1.2 $'))[1];


## Boolean switch controlling debug printing to STDERR.
our $DEBUG = 0;


## Things that are ok to Export.
our @EXPORT_OK = qw/ LIKE DONT_MIND HATE /;


## SQL Table name of this class
use constant TABLE_NAME => 'Preference_Audience';



##
# INSTANCE VARIABLES
# ==================
#
# A Preference contains these fields from the DB:
#
#  ID:          Integer object key
#  Editor_ID:   Integer flo::Record::Editor object key
#  Audience_ID: Integer flo::Record::Audience object key
#  Value:       Integer Value [LIKES | DONT_MIND | HATES]
#
# Of course, you'll always use methods to access these fields, won't you?
# That's good.  It might break if you don't.
##


##
# @objs = load flo::Record::Preference::Audience( %args );
# --------------------------------------------------------
#   Loads all Audience Preference objects matching given search criteria.
#   Accepts one or more of:
#
#     *  ID           load object by unique id
#     *  Editor       load by editor obj
#        Editor_ID    load by editor id
#        Audience_ID  load by language id
#        Name         load by language id (preserve API)
#        Value        load by value
#
#   Passing an Editor object will clobber the value of Editor_ID.
#   Additional or undefined fields are ignored.
#
#   Returns one object in scalar context, a list of Preference objects,
#   or undef on failure.
##

# inherit load()



##
# CLASS METHODS
# =============
##


##
# $args = $class->_filter_search_args(%args);
# -------------------------------------------
#   Filters search arguments, as defined by $class->load().
#   Returns \%args, or undef on error.
##
sub _filter_search_args
{
    my $class = shift || return;
    my $args  = $class->SUPER::_filter_search_args(@_) || return;

    # convert Name into Audience (Name doesn't exist in this table)
    $args->{Audience_ID} = delete $args->{Name} if (exists $args->{Name});

    return keys(%$args) ? $args : undef;
}




##
# INSTANCE METHODS
# ================
##


##
# $audience_id = $self->audience_id;
# ----------------------------------
#   Returns the value of the 'Audience_ID' attribute.
##
sub audience_id
{
    my $self = shift;
    return $self->{Audience_ID};
}


##
# $obj = $obj->set_audience_id ($id);
# -----------------------------------
#   Set the 'Audience_ID' attribute to $id.  Returns this object.
##
sub set_audience_id
{
    my $self             = shift;
    $self->{Audience_ID} = shift;
    return $self;
}


##
# $obj->audience;
# -------------
#   Returns the flo::Record::Audience object associated with this object.
##
sub audience
{
    my $self = shift;
    return load flo::Record::Audience (ID => $self->audience_id);
}


##
# $obj = $obj->set_audience ($audience);
# ----------------------------------
#   Set 'Audience_ID' attribute to the flo::Record::Audience object's id.
#   Returns this object.
##
sub set_audience
{
    my $self     = shift;
    my $audience = shift;
    return $self->set_audience_id ($audience->id);
}


##
# $name = $self->name;
# --------------------
#   Synonym for $self->audience_id to preserve API.
##
sub name
{
    my $self = shift;
    return $self->audience_id(@_);
}


##
# $obj = $obj->set_name ($name);
# ------------------------------
#   Synonym for $obj->set_audience_id to preserve API.
##
sub set_name
{
    my $self = shift;
    return $self->set_audience_id(@_);
}




1;


__END__

