# -------------------------------------------------------------------------------------
# flo::editor::Image
# -------------------------------------------------------------------------------------
# Author : Jean-Michel Hiver <jhiver@mkdoc.com>.
# Copyright : (c) MKDoc Holdings Ltd, 2003
# -------------------------------------------------------------------------------------
package flo::editor::Image;
use MKDoc::Util::Text2HTML;
use MKDoc::Config;
use flo::Standard;
use flo::Editor;
use strict;

use base qw /flo::Component
	     flo::editor::Mixin::compute_name
	     flo::editor::Mixin::normalize_name
	     flo::editor::Mixin::upload_file
	     flo::editor::Mixin::hr_name
	     /;


sub validate
{
    my $self = shift;
    
    # set up the callback for errors
    local $MKDoc::Ouch::CALLBACK;
    $MKDoc::Ouch::CALLBACK = sub { $self->add_error (@_) };
    
    return $self->validate_title() &
           $self->validate_image();
}


sub validate_image
{
    my $self = shift;
    return 1;
    # fixme

    #defined $self->{image} and $self->{image} ne '' or do {
#	new MKDoc::Ouch 'component/image/no_image';
#	return 0;
#    };
    
#    return 1;
}


sub validate_title
{
    my $self = shift;
    defined $self->{title} and $self->{title} !~ /^\s*$/ or do {
	new MKDoc::Ouch 'component/image/title_empty';
	return 0;
    };
    
    return 1;
}


##
# $self->internal_location();
# ---------------------------
# Returns the internal location associated with $self.
##
sub internal_location
{
    my $self = shift;
    return MKDoc::Config->IMAGE_HTTP_PATH . "/" . $self->{image};
}


sub preferred_extension
{
    my $self  = shift;
    my $file  = $self->{image} || return 'none';
    $file =~ s/^.*\///;
    my ($ext) = $file =~ /.*?\.(.*)/;
    $ext ||= $self->type();
    return $ext;
}


sub new
{
    my $class = shift;
    $class    = ref $class || $class;
    my $self  = bless { @_ }, $class;
    
    my $cgi = $self->{cgi};
    my $param_name = $self->{param_name};

    # if CGI is defined, then we probably want to do some stuff
    if (defined $cgi)
    {
	# update alt field
	if (defined $cgi->param ($param_name . "_alt"))
	{
	    my $alt = $cgi->param ($param_name . "_alt");
	    $self->{title} = $alt;
	}
	else
	{
	    my $empty = "";
	    $self->{title} = $empty;
	}
	
	# if the upload field is not empty, then the user
	# just uploaded a new image
	if (defined $cgi->param ($param_name . "_upload"))
	{
	    $self->{is_new} = 1;
	    my $new_image = $cgi->param ($param_name);
	    if ($new_image)
	    {
		my $new_image_no_slash  = $new_image;
		$new_image_no_slash =~ s/^.*\///g;
		$new_image_no_slash =~ s/^.*\\//g;
		
		my $new_image_friendly  = $self->normalize_name ($new_image_no_slash);
		my $dir                 = $self->compute_name;
		my $full_dir            = MKDoc::Config->IMAGE_DISK_PATH . "/" . $dir;
		$class->upload_file ('image_disk_path', $dir, $new_image_friendly, $cgi->param ($param_name))
		    or return $self;

		
		# attempts to set a sensible 'alt' image title by looking at the CGI field,
		# then the image name, and then defaulting to 'image_title' by default
		# (which should NEVER happen)
		$self->{image} = "$dir/$new_image_friendly";
		$self->{title} =
		    $cgi->param ($param_name . "_alt")    ||
		    $class->hr_name ($new_image_friendly) ||
		    'image_title';
	    }
	}
	else
	{
	    $self->{image} = $cgi->param ($param_name . "_img");
	}
    }
    
    return $self;
}


sub parse_xml
{
    my $self = shift;
    my $data = shift || return;
    
    # backwards compatibility horribleness
    $data =~ /<img src/ and do {
        my ($img, $alt) = $data =~ /<img src=\"(.*?)\" alt=\"(.*)\" \/>/;
        $self->{image}  = $img || ''; 
        $self->{title}  = html2text ($alt) || $self->{image} || '';
        return;
    };

    return $self->SUPER::parse_xml ($data, @_);
}


sub uri
{
    my $self = shift;
    return $self->is_saved() ?
        $self->SUPER::uri ( @_ ) :
	$self->URI (@_);
}


sub URI
{
    my $self = shift;
    my $src  = MKDoc::Config->IMAGE_HTTP_PATH . "/" . $self->{image};
    return $src;
}


sub description
{
    my $self = shift;
    return $self->{title};
}


sub title
{
    my $self = shift;
    return $self->{title};
}

1;
