# -------------------------------------------------------------------------------------
# flo::editor::Mixin::normalize_name
# -------------------------------------------------------------------------------------
#
#       Author : Jean-Michel Hiver (jhiver@mkdoc.com).
#    Copyright : (c) MKDoc Holdings Ltd, 2001
# 
#      Unauthorized modification, use, reuse, distribution or redistribution
#      of this module is stricly forbidden
#
#    Description:
#
#      Mixin to make file, images, photos, etc... names look better
#
# -------------------------------------------------------------------------------------
package flo::editor::Mixin::normalize_name;
use strict;


sub preferred_uri_name
{
    my $self = shift;
    my $name = $self->can ('title') ?
        $self->title :
	$self->type  ;
    
    return $self->normalize_name_nodot ($name);
}


sub normalize_name_nodot
{
    my $class = shift;
    my $name  = shift;
    $name = lc ($name);
    $name =~ s/[^a-z0-9-]/ /g;
    $name =~ s/\s+/-/g;
    $name =~ s/\-+/-/g;
    $name =~ s/^\-+//g;
    $name =~ s/\-+$//g;
    $name ||= $class->type();
    return $name;
}


sub normalize_name
{
    my $class = shift;
    my $name  = shift;
    $name = lc ($name);
    $name =~ s/[^a-z0-9-.]/ /g;
    $name =~ s/\s+/-/g;
    $name =~ s/^\-+//g;
    $name =~ s/\-+$//g;
    $name ||= $class->type();
    return $name;
}


1;
