# -------------------------------------------------------------------------------------
# flo::plugin::Account::RemoveConfirm
# -------------------------------------------------------------------------------------
# Author : Steve Purkis <spurkis@mkdoc.com>, Jean-Michel Hiver <jhiver@mkdoc.com>
# Copyright : (c) 2003, MKDoc Holdings Ltd.
# -------------------------------------------------------------------------------------
package flo::plugin::Account::RemoveConfirm;
use MKDoc::Config;
use flo::Record::Ticket;
use flo::Standard;
use Carp;
use Petal;

use strict;
use 5.008_000;
use utf8;


use flo::plugin::Account::Remove;
our @ISA = qw /flo::plugin::Account::Remove/;

sub template_path { '/account/remove_confirm' }

sub name { return $ISA[0]->name() }

sub activate
{
    my $self = shift;
    $self->SUPER::activate (@_) || return;
    $self->{ticket} = $self->_load_ticket() || return;
    return 1;
}

sub http_get
{
    my $self = shift;
    $self->render_http (
	self       => $self,
	object     => $self->parent,
	__input__  => 'XML',
	__output__ => 'XHTML',
       );    
    return 'TERMINATE';
}

sub http_post
{
    my $self = shift;
    
    my $user = $self->user();
    $user->delete();
    
    my $cgi  = flo::Standard::cgi();
    $cgi->delete ($cgi->param());
    print $cgi->redirect ( MKDoc::Config->PUBLIC_DOMAIN );
    
    return 'TERMINATE';
}


sub _load_ticket
{
    my $self = shift;
    my $cgi  = flo::Standard::cgi();
    my $tid  = $cgi->param ('t') || return;
    flo::Record::Ticket::clear_old_tickets_from_db;
    new flo::Record::Ticket ($tid);
}


1;
