# -------------------------------------------------------------------------------------
# flo::plugin::Account2::Confirm
# -------------------------------------------------------------------------------------
# Jean-Michel Hiver <jhiver@mkdoc.com>
# Copyright : (c) MKDoc Holdings Ltd, 2003.
# -------------------------------------------------------------------------------------
package flo::plugin::Account2::Confirm;
use flo::Record::Editor;
use flo::Standard;
use Petal::Mail;
use Petal;

use constant DEFAULT_EXPIRY_TIME => 15*24*60*60;

use base qw /flo::Plugin/;


sub template_path { return '/account2/confirm' };


sub activate
{
    my $self = shift;
    return unless ($self->SUPER::activate (@_));

    my $cgix = flo::Standard::cgi()->new();
    $cgix->param ('t') || return;
    
    my $user_t = flo::Standard::table ('Editor');
    my $cond   = new lib::sql::Condition();
    $cond->add ('Disabled', '!=', '0');
    my $q      = $user_t->search ($cond);
    
    while (my $user = $q->next())
    {
	warn $user->login() . " " . $user->signature();
        if ($user->signature() eq $self->signature())
        {
            $user->{Disabled} = 0;
            $user->save();
            return 1;
        }
    }
    
    return;
}


sub signature
{
    my $self = shift;
    my $cgix = flo::Standard::cgi()->new();
    return $cgix->param ('t');
}


1;


__END__
