# -------------------------------------------------------------------------------------
# flo::plugin::Account2::Preferences
# -------------------------------------------------------------------------------------
# Author      : Steve Purkis <spurkis@mkdoc.com>,
# Last-Update : Jean-Michel Hiver <jhiver@mkdoc.com>
# Copyright   : MKDoc Holdings Ltd, 2003
#
# This plugin lets an existing user edit their Language, Audience, and Newsletter
# preferences.
# -------------------------------------------------------------------------------------
package flo::plugin::Account2::Preferences;
use MKDoc::Ouch;
use flo::Standard;
use flo::Plugin;
use Carp;
use Petal;
use strict;
use 5.008_000;
use utf8;


use base qw /flo::Plugin/;


sub template_path { return '/account2/preferences' };


sub http_get
{
    my $self = shift;
    $self->render_http (
	self       => $self,
	object     => $self->parent,
	__input__  => 'XML',
	__output__ => 'XHTML',
       );
    return 'TERMINATE';
}


sub http_post
{
    my $self = shift;
    my $cgi  = $self->cgi();
    $self->_update_preferences_from_cgi();
    $self->{http_post} = 1;
    return $self->http_get();
}


sub _update_preferences_from_cgi
{
    my $self   = shift;
    my $prefs  = $self->preferences;
    my $cgi    = $self->cgi;
    
    foreach my $param ($cgi->param)
    {
	if ($param =~ /^((?:general)|(?:language)|(?:audience))_([\w\-\.\:]+)$/)
	{
	    my $type      = $1;
	    my $name      = $2;
	    my $new_value = $cgi->param($param);
	    
	    $cgi->delete($param);
	    next unless defined($new_value);
	    
	    my $get_method = "$type\_preference";
	    my $set_method = "set_$type\_preference";
	    my $old_value  = $prefs->$get_method ($name);
	    unless (defined $old_value)
	    {
		$self->_notify_error ($type, $name);
	    }
	    else
	    {
		if ($new_value ne $old_value)
		{
		    unless ($prefs->$set_method ($name, $new_value))
		    {
			$self->_notify_error ($type, $name);
		    }
		}
	    }
	}
    }
}


sub _notify_error
{
    my $class = shift;
    my $type  = shift;
    my $name  = shift;
  CASE:
    local $_ = "$type.$name";
    for ($_)
    {
	/email\.not_set/        and do { new MKDoc::Error ( template => '/error/email.not_set/'      ); last CASE };
	/first_name\.not_set/   and do { new MKDoc::Error ( template => '/error/first_name.not_set/' ); last CASE };
	/family_name\.not_set/  and do { new MKDoc::Error ( template => '/error/last_name.not_set/'  ); last CASE };
	/password\.not_set/     and do { new MKDoc::Error ( template => '/error/password.not_set/'   ); last CASE };
	/password\.too_short/   and do { new MKDoc::Error ( template => '/error/password.length/'    ); last CASE };
	/password\.mismatch/    and do { new MKDoc::Error ( template => '/error/password.mismatch/'  ); last CASE };
	new MKDoc::Error ( template => '/error/', info => "preferences.$type.$name not defined" );
    }
}


sub preferences
{
    my $self = shift;
    return $self->user()->preferences();
}


sub activate
{
    my $self = shift;
    return unless ($self->SUPER::activate(@_));
    return unless ($self->user);
    return 1;
}


1;


__END__
