# -------------------------------------------------------------------------------------
# flo::plugin::Account2::Subscribe
# -------------------------------------------------------------------------------------
# Author : Jean-Michel Hiver <jhiver@mkdoc.com>
# Copyright : (c) MKDoc Holdings Ltd, 2003.
# -------------------------------------------------------------------------------------
package flo::plugin::Account2::Subscribe;
use flo::Record::Editor;
use flo::Standard;
use Petal::Mail;
use Petal;

use constant DEFAULT_EXPIRY_TIME => 15*24*60*60;

use base qw /flo::Plugin/;

sub template_path { '/account2/subscribe' }


sub http_get
{
    my $self = shift;
    $self->render_http (
	self       => $self,
	object     => $self->parent,
	__input__  => 'XML',
	__output__ => 'XHTML',
       );    
    return 'TERMINATE';
}


sub http_post
{
    my $self = shift;
    my $cgi    = flo::Standard::cgi();
    
    my $login = $self->_generate_login();
    my $pass  = $self->_generate_pass();
    
    my $fname = $cgi->param ('first_name');
    my $lname = $cgi->param ('last_name');
    my $email = $cgi->param ('email');
    
    $self->{user} = new flo::Record::Editor (
	Login       => $login,
	Password    => $pass,
	First_Name  => $fname,
	Family_Name => $lname,
	Email       => $email,
	Disabled    => time + DEFAULT_EXPIRY_TIME,
       );

    $self->_send_mail if (defined $self->{user});
    return $self->http_get (@_);
}


sub user
{
    my $self = shift;
    my $user = $self->{user};
    return $user;
}


sub _send_mail
{
    my $self = shift;
    my $mail = new Petal::Mail (
	file             => 'account2/emails/subscribe',
	language         => $self->language(),
       );
    
    eval {
	$mail->send (
	    self   => $self,
	    object => $self->parent(),
	   );
    };
    defined $@ and $@ and do {
	warn $@;
	new MKDoc::Ouch 'mail/cannot_create';
	return 0;
    };
}


sub _generate_pass
{
    return join '', map { chr (ord ('a') + int rand 26) } 1..8;
}


sub _generate_login
{
    my $self   = shift;
    my $cgi    = flo::Standard::cgi();
    
    my $login = $cgi->param ('email');
    $login    =~ s/\@.+//;
    $login    = lc ($login);
    $login    =~ s/[^a-z]//g;
    $login  ||= 'login';
    
    length ($login) > 12 && do { $login = substr ($login, 0, 12) };
    
    my $user_t = flo::Standard::table ('Editor');
    $user_t->get (Login => $login) || return $login;
    
    my $count = 2;
    my $new_login = $login . $count;
    while ($user_t->get (Login => $new_login))
    {
	$count++;
	$new_login = $login . $count;
    }
    
    return $new_login;
}


1;


__END__
