package flo::plugin::Admin::AudienceDelete;
use strict;
use warnings;
use flo::Standard;
use flo::Record::Editor;
use base qw /flo::Plugin/;


sub activate
{
    my $self = shift;
    $self->SUPER::activate (@_) || return;
    $self->SUPER::user()->id() == 1    || return;
    
    my $cgi = $self->cgi();
    my $audience_id = $cgi->param ('id') || return;
    my $audience_t = flo::Standard::table ('Audience');
    $self->{audience} = $audience_t->get ($audience_id) || return;
    
    return 1;
}


sub audience
{
    my $self = shift;
    return $self->{audience};
}


sub template_path { 'admin/audience_delete' }


sub http_get
{
    my $self = shift;
    $self->render_http (
	self => $self,
	__output__ => 'XHTML',
       );
    
    return 'TERMINATE';
}


sub http_post
{
    my $self = shift;
    
    my $audience_t = flo::Standard::table ('Audience');
    my $audience   = $self->audience();
    $audience_t->delete ( ID => $audience->id() );

    use flo::plugin::Admin::AudienceList;
    my $audiencelist_p = new flo::plugin::Admin::AudienceList();
    
    my $cgi = flo::Standard::cgi();
    print $cgi->redirect ($audiencelist_p->uri());
    return 'TERMINATE';
}


1;
