package flo::plugin::Admin::UserList;
use strict;
use warnings;
use flo::Standard;
use base qw /flo::Plugin/;


sub activate
{
    my $self = shift;
    $self->SUPER::activate (@_) || return;
    $self->user()->id() == 1    || return;
    return 1;
}


sub template_path { 'admin/user_list' }


sub http_get
{
    my $self = shift;
    $self->render_http (
	self => $self,
	__output__ => 'XHTML',
       );
    
    return 'TERMINATE';
}


sub users
{
    my $self = shift;
    my $editor_t = flo::Standard::table ('Editor');
    my @res = $editor_t->select (
	cols => '*',
	sort => [ 'First_Name', 'Family_Name' ],
	desc => 0,
       )->fetch_all();

    return wantarray ? @res : \@res;
}


1;
