# -------------------------------------------------------------------
# flo::plugin::Cache::Writer
# -------------------------------------------------------------------
# Author: Jean-Michel Hiver <jhiver@mkdoc.com>
# Copyright: (c) MKDoc Holdings Ltd, 2003
# Description: flo::plugin::Cache::Fake sends the data
# that the current document outputs without caching it.
# -------------------------------------------------------------------
package flo::plugin::Cache::Writer;
use strict;
use warnings;
use Encode;
use Carp;
use flo::Standard;
use flo::HTTP::Header;
use 5.008_000;

use base qw /flo::plugin::Cache::Reader/;


sub name { '' }


sub activate
{
    my $self = shift;
    flo::Standard::raw_path_info          || return;
    flo::Standard::raw_path_info =~ /\./  and return;
    flo::Standard::raw_path_info =~ /\/$/ || return;
    $self->document()                     || return;
    return 1;
}


sub template_path
{
    my $self = shift;
    return 'document/' . $self->template();
}


sub run
{
    my $self = shift;
    my $data = $self->render (
        self       => $self,
	__input__  => 'XML',
	__output__ => 'XHTML'
       );
 
    $self->set_cached_data ($data);
    $self->send_data ($data);
    return 'TERMINATE';
}


sub set_cached_data
{
    my $self  = shift;
    my $data  = shift;
    my $cache = $self->cache_object();
    my $uri   = flo::Standard::cgi()->self_url();
    $cache->set ( $uri, $data, $self->cache_control() * 60 );
}


1;
