# -------------------------------------------------------------------
# flo::plugin::Logout
# -------------------------------------------------------------------
# Author: Jean-Michel Hiver <jhiver@mkdoc.com>
# Copyright: (c) MKDoc Holdings Ltd, 2003
# Description: flo::plugin::Logout sends the data
# that the current document outputs without caching it.
# -------------------------------------------------------------------
package flo::plugin::Logout;
use strict;
use warnings;
use flo::Standard;
use base qw /flo::Plugin/;


sub run
{
    my $self = shift;
    $self->_create_logout_stamp();
    
    my $cgi  = flo::Standard::cgi();
    $cgi->path_info ('/');
    print $cgi->redirect ($cgi->self_url);
    
    return 'TERMINATE';
}


sub _create_logout_stamp
{
    my $self  = shift;
    my $login = uc ($ENV{REMOTE_USER} || '');
    $login || return;
    my $file  = '/tmp/MKD-AUTH__' . $login . '@' . flo::Standard::cgi()->server_name();

    open FP, ">$file" || do {
        warn "Cannot write-open $file";
        return;
    };
    print FP '';
    close FP;
}


1;
