# -------------------------------------------------------------------
# flo::plugin::Print
# -------------------------------------------------------------------
# Author: Jean-Michel Hiver <jhiver@mkdoc.com>
# Copyright: (c) MKDoc Holdings Ltd, 2003
# Description: flo::plugin::Cache::Fake sends the data
# that the current document outputs without caching it.
# -------------------------------------------------------------------
package flo::plugin::Print;
use strict;
use warnings;
use Encode;
use Carp;
use flo::Standard;
use flo::HTTP::Header;
use 5.008_000;

use base qw /flo::Plugin/;


sub _name_default { '.print.html' }


sub mode
{
    my $self = shift;
    my $mode = 'print';
    return $mode;
}


sub is_mode
{
    my $self = shift;
    my $mode = shift;
    return $mode eq $self->mode;
}


sub template_path
{
    my $self = shift;
    return 'print';
}


sub run
{
    my $self = shift;
    $self->render_http (
        self       => $self,
	__input__  => 'XML',
	__output__ => 'XHTML'
       );
    
    return 'TERMINATE';
}


1;
