# -------------------------------------------------------------------------------------
# flo::plugin::Shop::Details
# -------------------------------------------------------------------------------------
# Author : Jean-Michel Hiver <jhiver@mkdoc.com>.
# Copyright : (c) MKDoc Holdings Ltd, 2003
#
# Provides a method for the user to enter details when checking out.
# -------------------------------------------------------------------------------------
package flo::plugin::Shop::Details;
use base qw /flo::Plugin/;
use MKDoc::Session;
use MKDoc::ECommerce::Address;
use MKDoc::ECommerce::Order;
use flo::plugin::Shop::Order;
use warnings;
use strict;
use Petal;
use flo::Record::Editor;


##
# $self->template_path();
# -----------------------
# Returns the template path in which to find the shopping
# basket templates.
##
sub template_path
{
    my $self = shift;
    return 'shop/details';
}


##
# $self->http_post;
# -----------------
# Attempts to create a valid address, store it, and create an order
# with worldpay's gateway.
##
sub http_post
{
    my $self  = shift;
    my $cgi   = $self->cgi();
    my $session = $self->session() || return $self->http_get();
    
    # try to set the address in the session
    # if the address is invalid, re-display the form 
    my %param = map { $_ => $cgi->param ($_) } $cgi->param();
    $param{country} = $session->{country};
    
    my $addr  = new MKDoc::ECommerce::Address (%param);
    $addr || return $self->http_get();
    
    $session->{address} = $addr;
    $session->save();
    
    
    # create an order object with the session_id, the address
    # and the basket object and save it
    my $order = new MKDoc::ECommerce::Order (
        session_id => $session->id(),
        address    => $session->{address},
        basket     => $session->{basket}
    );
    $order->save();
    
    
    # now that we have created the order, redirect to the order
    # page from where the payment can be made. 
    my $uri = $flo::plugin::Shop::Order::CURRENT->uri();
    $uri    =~ s/^(https?:\/\/.*?\/).*?(\..*)$/$1$2/;
    $uri   .= "?id=$order->{id}";
    print $cgi->redirect ($uri);
    return 'TERMINATE';
}


##
# $self->http_get;
# ----------------
# Displays the form which lets the editor choose which audiences
# the current document relates to.
##
sub http_get
{
    my $self = shift;
    
    # initialize CGI parameters with default values
    $self->_http_get_initialize_cgi();
    
    $self->render_http (
	self       => $self,
	__input__  => 'XML',
	__output__ => 'XHTML',
       );
    
    return 'TERMINATE';
}


sub _http_get_initialize_cgi
{
    my $self = shift;
    my $cgi  = $self->cgi();
    $cgi->param ('submit_ok') && return;
    
    my $session  = $self->session()    || return;
    my $address = $session->{address} || return;
    
    for (keys %{$address})
    {
	$cgi->param ($_, $address->{$_});
    }
}


sub session
{
    my $self = shift;
    return MKDoc::Session->load();
}


1;


__END__
