#!/usr/bin/perl

# use required modules, just to make sure we have them
use CGI;
use XML::Parser;
use XML::RSS;
use Petal;
use Text::Unidecode;
use Unicode::String;
use Unicode::Normalize;
use DBI;
use DBD::mysql;
use Mail::IMAPClient;
use MIME::Base64;
use Date::Manip;
use Time::ParseDate;
use Cache::Cache;

# use modules required for install
use MKDoc::Site::ConfigWriter::MKDocRegistrer;
use MKDoc::Site::ConfigWriter::Httpd_Conf;
use MKDoc::Site::Deploy::DB;
use MKDoc::Site::ConfigUI;
use MKDoc::Site::Config;
use warnings;
use strict;

$MKDoc::Site::Config::CONFIG = do {
    my $config = MKDoc::Site::ConfigUI->new ( MKDoc::Site::ConfigUI->_new_attributes );
    $config->run();
    $config->is_ok() || do {
	print "Exit.\n";
	exit;
    };
    $config;
};

my $site_dir = $MKDoc::Site::Config::CONFIG->{'site_dir'};


$::LOG_DIR = $ENV{LOG_PREFIX} ?
do {
    my $dir = $MKDoc::Site::Config::CONFIG->{'site_dir'};
    $dir =~ s/^.*\///;
    $dir =~ s/\/$//;

    my $prefix = $ENV{LOG_PREFIX};
    $prefix =~ s/\/$//;

    "$prefix/$dir";
} : $site_dir . '/log';


$::CACHE_DIR = $ENV{CACHE_PREFIX} ?
do {
    my $dir = $MKDoc::Site::Config::CONFIG->{'site_dir'};
    $dir =~ s/^.*\///;
    $dir =~ s/\/$//;

    my $prefix = $ENV{CACHE_PREFIX};
    $prefix =~ s/\/$//;

    "$prefix/$dir";
} : $site_dir . '/cache';


$::TEMP_DIR = $ENV{TEMP_PREFIX} ?
do {
    my $dir = $MKDoc::Site::Config::CONFIG->{'site_dir'};
    $dir =~ s/^.*\///;
    $dir =~ s/\/$//;

    my $prefix = $ENV{TEMP_PREFIX};
    $prefix =~ s/\/$//;

    "$prefix/$dir";
} : undef;


print "\n";
setup_files();

print "\nWriting apache config files\n";

MKDoc::Site::ConfigWriter::Httpd_Conf->setup();
MKDoc::Site::Deploy::DB->setup();
MKDoc::Site::ConfigWriter::MKDocRegistrer->setup();

my $admin = MKDoc::Site::ConfigWriter->site_user_domain;
$admin    = MKDoc::Site::ConfigWriter->is_site_user_domain_https() ? "https://$admin/" : "http://$admin/";

print <<EOF;

Your mkdoc site has been installed. You should now restart
your http server. Once this is done, go to the following
address:

  $admin

EOF

$::KEEP_TABLES && do {
print <<EOF;
Since you chose to keep your existing database, your admin
password has not been changed.

EOF
};

$::KEEP_TABLES || do {
print <<EOF;
Your default connection parameters will be:

  user: admin
  password: $::ADMIN_PASSWD

EOF
};

sub setup_files
{
    my $config        = $MKDoc::Site::Config::CONFIG;
    my $site_dir      = $config->{'site_dir'};
    my $server_admin  = $config->{'server_admin'};
    my $public_domain = $config->{'public_domain'};
    my $user_domain   = $config->{'user_domain'};
 
    make_dir ("$site_dir");
    make_dir ("$site_dir/su");
    make_dir ("$site_dir/httpd");
    make_dir ("$site_dir/resources");
    make_dir ("$site_dir/resources/templates");
    make_dir ("$site_dir/resources/skin");
    make_dir ("$site_dir/data");
    make_dir ("$site_dir/static");
    make_dir ("$site_dir/static/files");
    make_dir ("$site_dir/static/images");
    make_dir ($::LOG_DIR);
    make_dir ($::TEMP_DIR);
    make_dir ($::CACHE_DIR);
    
    # this might be a bit dubious on a multi-user system... 
    $::TEMP_DIR && chmod (0777, $::TEMP_DIR);
    chmod (0777, $::CACHE_DIR);
    chmod (0777, "$site_dir/data");
    chmod (0777, "$site_dir/static/files");
    chmod (0777, "$site_dir/static/images");

    # install mksetenv script
    open FP, ">$site_dir/mksetenv.sh" || do {
        warn "Cannot write-open '$site_dir/mksetenv.sh'";
        return;
    };

    print FP join "\n", (
        qq |source $ENV{MKDOC_DIR}/mksetenv.sh|, 
        qq |export SITE_DIR="$site_dir"|,
        qq |export SERVER_ADMIN="$server_admin"|,
        qq |export PUBLIC_DOMAIN="$public_domain"|,
        qq |export USER_DOMAIN="$user_domain"|,
    );

    close FP;
}


sub make_dir
{
    my $dir = shift || return;
    print "Creating $dir\n";
    -d $dir and return;
    mkdir $dir || die "Cannot create $dir!";
}


1;
