#!/usr/bin/perl
use strict;
use warnings;

$ENV{MKDOC_DIR}         || die "MKDOC_DIR is not defined. Aborting.";
my $some_arg    = shift || die "Usage: $0 <site_prefix>/<domain_name>
  Example: $0 /var/www/your-site.net\n";
$some_arg =~ s/\/$//;

my ($sites, $base_domain) = $some_arg =~ /(.*)\/(.*)/;
my $db_domain = $base_domain;
$db_domain =~ s/[^a-z0-9]/_/gi;

$base_domain  || die "\$base_domain is empty?";
$db_domain    || die "\$db_domain is empty?";

my $SITE_DIR      = "$sites/$base_domain";
my $PUBLIC_DOMAIN = "http://www.$base_domain/";
my $USER_DOMAIN   = "http://users.$base_domain/";
my $SERVER_ADMIN  = "admin\@$base_domain";
my $DATABASE_NAME = $db_domain;
my $ORGANIZATION_NAME = "$base_domain";
my $ORGANIZATION_EMAIL = "info\@$base_domain";
$ORGANIZATION_NAME =~ s/\b(\w)/\U$1/g;

# my $mysql_command = $ENV{MYSQL_COMMAND} || 'mysql -uroot';
# system (qq /echo "create database if not exists $db_domain" | $mysql_command/);

system (qq |export SITE_DIR="$SITE_DIR"; export PUBLIC_DOMAIN="$PUBLIC_DOMAIN"; export USER_DOMAIN="$USER_DOMAIN"; export SERVER_ADMIN="$SERVER_ADMIN"; export DATABASE_NAME="$DATABASE_NAME"; export ORGANIZATION_NAME="$ORGANIZATION_NAME"; export ORGANIZATION_EMAIL="$ORGANIZATION_EMAIL"; perl $ENV{MKDOC_DIR}/tools/install-details.pl|);
