# -------------------------------------------------------------------------------------
# MKDoc::Handler::Initialize
# -------------------------------------------------------------------------------------
# Author: Jean-Michel Hiver <jhiver@mkdoc.com>.
# Copyright: (c) MKDoc Holdings Ltd, 2001
# Description: Initializes MKDoc framework for subsequent handlers.
# -------------------------------------------------------------------------------------
package MKDoc::Handler::Initialize;
use strict;
use warnings;
use Petal;
use MKDoc::Config;
use Carp;
use lib::sql::DBH;
use lib::sql::Table;

use CGI qw(-compile :all);


sub sillyness
{
    $::MKD_IS_INIT,
}


sub handler
{
    $CGI::USE_PARAM_SEMICOLONS = 1;
    + lib::sql::DBH->disconnect;
    
    clean_globals();
    
    $Petal::DECODE_CHARSET = 'utf8';
    $Petal::ENCODE_CHARSET = 'utf8';    
    $Petal::BASE_DIR = undef;
    @Petal::BASE_DIR = (MKDoc::Config->TEMPLATE_DIR2, MKDoc::Config->TEMPLATE_DIR);
    
    # loads database table schemas
    + lib::sql::Table->load_state (MKDoc::Config->SITE_DIR .'/su');
    
    $::MKD_IS_INIT = 1;
    return 1;
}


# reinitializes global variables to their default values
sub clean_globals
{
    foreach my $key (keys %::)
    {
	if ($key =~ /^MKD_/)
	{
	    my $val = $ {$::{$key}};
	    next unless (defined $val);            # already reinitialized...
	    next if (ref $val eq 'MKDoc::Config'); # handled by process()
	    
	    # if $val is a hashref, then reinitialize
	    # to an empty hashref
	    if (ref $val eq 'HASH')
	    {
		$ {$::{$key}} = {};
		next;
	    }
	    
	    # if $val if an arrayref, then reinitialize
	    # to an empty arrayref
	    if (ref $val eq 'ARRAY')
	    {
		$ {$::{$key}} = [];
		next;
	    }
	    
	    # otherwise, just undef the variable
	    $ {$::{$key}} = undef;
	}
    }
}


1;


__END__
