# -----------------------------------------------------------------------------
# MKDoc::Site::Deploy - Abstract Deploy class
# -----------------------------------------------------------------------------
#
#       Author : Steve Purkis <spurkis@mkdoc.com>
#    Copyright : (c) 2002, MKDoc Holdings Ltd.
#
#      Unauthorized modification, use, reuse, distribution or redistribution
#      of this module is stricly forbidden.
#
#    Description:
#
#       Abstract class for MKDoc Site Deployment objects.
#
#    Synopsis:
#
#       use base qw/ MKDoc::Site::Deploy /;
#
#       $self->ask_user($question, @answers);
#
# -----------------------------------------------------------------------------
package MKDoc::Site::Deploy;
use strict;
use warnings;


sub class
{
    my $class = shift;
    return ref $class || $class;
}


sub new
{
    my $class = shift->class;
    return bless { @_ }, $class;
}


##
# Instance Methods
# =============================================================================
#
# Accessors & Instance Variables
# -----------------------------------------------------------------------------
#
# Use *variable()* to get, and *set_variable()* to set instance variables.
# Set methods should all return $self.
#
# *Instance Variables:*
##

##   config         hash of config variables.
sub set_config {
    my $self        = shift;
    $self->{config} = shift;
    return $self;
}

sub config
{
    my $self = shift;
    return $self->{config};
}


##   site_dir       mkdoc site directory being setup
sub set_site_dir {
    my $self          = shift;
    $self->{site_dir} = shift;
    return $self;
}

sub site_dir {
    my $self = shift;
    return $self->{site_dir};
}


##   verbose        switch controlling verbose printing to STDOUT.
sub set_verbose {
    my $self         = shift;
    $self->{verbose} = shift;
    return $self;
}

sub verbose {
    my $self = shift;
    return $self->{verbose};
}


##   interactive    switch specifying whether or not to interact with user.
sub set_interactive {
    my $self         = shift;
    $self->{interactive} = shift;
    return $self;
}

sub interactive {
    my $self = shift;
    return $self->{interactive};
}


##
# Other
# -----------------------------------------------------------------------------
#
# $obj->say( @text );
# -------------------
# Prints @text to STDOUT if verbose is true.  Adds a newline if needed.
##
sub say
{
    my $self = shift;
    return unless $self->verbose;
    push (@_, "\n") unless ($_[0] =~ /\n$/);
    print @_;
}


##
# $ans = $obj->ask_user( $question, @answers )
# --------------------------------------------
# Asks the user a $question if interactive mode is on.
#
# Expects a case-insensitive @answer from those listed, and keeps asking
# until it gets one.
#
# Returns the answer they selected, or undef if interactive mode is off.
##
sub ask_user
{
    my $self     = shift;
    my $question = shift;
    my @answers  = @_;

    return undef unless ($self->interactive);

  ASK_QUESTION:
    print("\n$question [", join(',', @answers), '] ');

    my $answer = <STDIN>;
    chomp($answer);

    foreach (@answers) { return $_ if ($answer =~ /$_/i) }

    print "Sorry, I don't understand [$answer].\n";
    goto ASK_QUESTION;
}


1;

__END__
