#!/usr/bin/perl
# -------------------------------------------------------------------------------------
#       Author : Jean-Michel Hiver <jhiver@mkdoc.com>.
#    Copyright : (c) MKDoc Holdings Ltd, 2003
#
#    Description:
#
#      Tiny wrapper script which pulls and triggers MKDoc.pm which controls the
#      execution flow of the program.
# -------------------------------------------------------------------------------------
use MKDoc;
use Data::Dumper;
use strict;
use warnings;

eval { MKDoc->process() };
if (defined $@ and $@)
{
    print "Status: 500 Internal Server Error\n";
    print "Content-Type: text/html; charset=UTF-8\n\n";
    if (ref $@) { $@ = Dumper ($@) }
    $@ = Dumper (\%ENV) . "\n\n" . $@;
    warn "SOFTWARE_ERROR\n\n" . $@ . "\n\n";
}

BEGIN {
    $SIG{'__WARN__'} = sub {
	# trap some common error strings that otherwise flood the log files
	warn $_[0] unless ($_[0] =~ /byte of utf8 encoded char at/ or
			   $_[0] =~ /is deprecated/                or
                           $_[0] =~ /IMAPClient\.pm line/);
    }
}


1;
