# -------------------------------------------------------------------------------------
# flo::ComponentPlugin
# -------------------------------------------------------------------------------------
#
#     Author   : Jean-Michel Hiver
#    Copyright : (c) 2001, MKDoc Holdings Ltd
#
#      Unauthorized modification, use, reuse, distribution or redistribution
#      of this module is stricly forbidden.
#
#   Description:
#
#      A base module for MKDoc plugins, which implements or defines the base
#      methods which a plugin should implement.
#
# -------------------------------------------------------------------------------------
package flo::ComponentPlugin;
use flo::Standard;
use strict;
use warnings;
use Carp;
use flo::Plugin;
use base qw /flo::Plugin/;


##
# $self->activate;
# ----------------
#   Returns TRUE if this plugin needs to catch the request,
#   FALSE otherwise.
##
sub activate
{
    my $self = shift;

    my $cgi = $self->cgi()->new();
    my $path_info = $cgi->path_info;
    
    # if the path_info references a document, return
    $path_info =~ /\/$/ and return;
    
    # remove everything that's not the component name
    $path_info =~ s/^.*\///;
    $path_info =~ s/\,.*$//;
    
    my $document  = flo::Standard::current_document() || return;
    my $component = $document->get ($path_info) || return;
    $self->{component} = $component;
    
    return 1;
}


##
# $class->type;
# -------------
#   Returns the type of component that this plugin handles, i.e.
#   'text', 'html', etc. To be subclassed.
##
sub type
{
    my $class = shift;
    $class = ref $class || $class;
    confess $class . "::type is not implemented";
}


##
# $class->extension;
# ------------------
#   Returns the extension that will be used to display that
#   component plugin.
##
sub extension
{
    my $class = shift;
    $class = ref $class || $class;
    return 'html';
}


##
# $self->component;
# -----------------
#   Returns the component which is associated with this
#   plugin.
##
sub component
{
    my $self = shift;
    return $self->{component};
}


##
# $self->uri;
# -----------
#   Returns the URI of this object.
##
sub uri
{
    my $self = shift;
    my $cgix = $self->cgi()->new;
    $cgix->delete ($_) for ($cgix->param);
    while (@_)
    {
	my ($key, $val) = (shift, shift);
	$cgix->param ($key, $val);
    }

    $self->component() || die "Have you forgot to /activate the plugin?";    
    $cgix->path_info ($self->component->path);
    return $cgix->self_url;
}


1;
