# -------------------------------------------------------------------------------------
# flo::editor::Discussion
# -------------------------------------------------------------------------------------
# Author : Jean-Michel Hiver <jhiver@mkdoc.com>.
# Copyright : (c) MKDoc Holdings Ltd, 2003
# -------------------------------------------------------------------------------------
package flo::editor::Discussion;
use flo::plugin::Discussion::IMAP;
use flo::Standard;
use strict;
use warnings;


use base qw /flo::Component/;


sub preferred_extension { 'html' }


sub activate
{
    my $self = shift;
    return unless ($self->SUPER::activate (@_));
    return MKDoc::Config->IMAP_SERVER;
}


sub _initialize
{
    my $self = shift;
    my $args = $self->cgi_args() || return;

    $self->set_mbox        ($args->{mbox} || '');
    $self->set_title       ($args->{title} || '');
    $self->set_description ($args->{description} || '');
}


sub validate
{
    my $self = shift;
    
    # set up the callback for errors
    local $MKDoc::Ouch::CALLBACK;
    $MKDoc::Ouch::CALLBACK = sub { $self->add_error (@_) };

    return $self->validate_mbox()  &
           $self->validate_title() &
	   $self->validate_description();
}


sub validate_mbox
{
    my $self = shift;

    my $mbox = $self->{mbox} || do {
	new MKDoc::Ouch 'component/discussion/mbox_empty';
	return 0;
    };
    
    $mbox =~ /^[a-z0-9-]+$/ or do {
	new MKDoc::Ouch 'component/discussion/mbox_malformed';
	return 0;
    };
    
    $mbox =~ /-$/ and do {
	new MKDoc::Ouch 'component/discussion/mbox_malformed';
	return 0;
    };
    
    $mbox =~ /^-/ and do {
	new MKDoc::Ouch 'component/discussion/mbox_malformed';
	return 0;
    };
    
    $mbox =~ /--/ and do {
	new MKDoc::Ouch 'component/discussion/mbox_malformed';
	return 0;
    };
    
    return 1;
}


sub validate_title
{
    my $self = shift;
    $self->{title} || do {
	new MKDoc::Ouch 'component/discussion/title_empty';
	return 0;
    };
    
    return 1;
}


sub validate_description
{
    my $self = shift;
    $self->{description} || do {
	new MKDoc::Ouch 'component/discussion/description_empty';
	return 0;
    };
    
    return 1;
}


##
# $self->mbox;
# ------------
#   Sets the IMAP mbox which is associated with that component.
##
sub mbox
{
    my $self = shift;
    return $self->{mbox};
}


##
# $self->set_mbox ($mbox_name);
# -----------------------------
#   $mbox_name - name of the mbox to set
##
sub set_mbox
{
    my $self = shift;
    $self->{mbox} = shift;
}


##
# $self->title;
# -------------
#   Gets the title attribute of that component
##
sub title
{
    my $self = shift;
    return $self->{title};
}


##
# $self->set_title ($title);
# --------------------------
#   $title - the title to set
#
#   Gets the title attribute of that component
##
sub set_title
{
    my $self = shift;
    my $title = shift; # u_shift
    $self->{title} = join ' ', split /(?:\n|\r)/, $title;
    $self->{title} =~ s/^\s+//;
    $self->{title} =~ s/\s+$//;
}


##
# $self->description;
# -------------------
#   Gets the description attribute of that component
##
sub description
{
    my $self = shift;
    return $self->{description};
}


##
# $self->set_description ($description);
# --------------------------------------
#   $description - the description to set
#
#   Gets the description attribute of that component
##
sub set_description
{
    my $self = shift;
    my $description = shift; # u_shift
    $self->{description} = join ' ', split /(?:\n|\r)/, $description;
    $self->{description} =~ s/^\s+//;
    $self->{description} =~ s/\s+$//;
}


##
# $self->generate_xml;
# --------------------
#   Serializes the object to XML
##
sub generate_xml
{
    my $self = shift;
    
    # makes sure that the mbox exists
    my $imap = new flo::plugin::Discussion::IMAP;
    $imap->mbox_create ($self->mbox);

    my $cgi = delete ($self->{cgi});
    my $param_name = delete ($self->{param_name});
    my $res = $self->SUPER::generate_xml (@_);
    $self->{cgi} = $cgi;
    $self->{param_name} = $param_name;
    return $res;
}


1;
