# -------------------------------------------------------------------------------------
# flo::editor::Mixin::hr_name
# -------------------------------------------------------------------------------------
#
#       Author : Jean-Michel Hiver (jhiver@mkdoc.com).
#    Copyright : (c) MKDoc Holdings Ltd, 2001
# 
#      Unauthorized modification, use, reuse, distribution or redistribution
#      of this module is stricly forbidden
#
#    Description:
#
#      Mixin to compute human readable names from normalized MKDoc names
#
# -------------------------------------------------------------------------------------
package flo::editor::Mixin::hr_name;
use strict;


##
# $class->hr_name;
# ----------------
#   Static method that computes a human readable names from a
#   normalized MKDoc name.
##
sub hr_name
{
    my $class = shift;
    my $string = shift;
    return unless (defined $string);
    
    $string =~ s/\..*?$//;
    $string =~ s/-/ /g;
    $string =~ s/\b(\w)/\U$1/g;
    return $string;
}


1;
