# -------------------------------------------------------------------------------------
# flo::plugin::Admin::Component::Copy
# -------------------------------------------------------------------------------------
# Author : Jean-Michel Hiver <jhiver@mkdoc.com>
# Copyright : (c) MKDoc Holdings Ltd, 2003
#
# Lets an editor delete the current document. Redirects to the parent document.
# -------------------------------------------------------------------------------------
package flo::plugin::Admin::Component::Copy;
use MKDoc::Config;
use MKDoc::Error;
use flo::Standard;
use Encode;
use strict;
use warnings;
use 5.008_000;
use Carp;


use base qw /flo::ComponentPlugin/;


sub template_path { 'admin/component_copy' }


sub uri
{
    my $self = shift;
    my $uri  = $self->SUPER::uri();
    $uri .= ',copy';
    return $uri;
}


##
# $self->activate;
# ----------------
# Returns TRUE if this plugin can be activated, FALSE
# otherwise.
##
sub activate
{
    my $self = shift;
    return unless ($self->flo::ComponentPlugin::activate (@_));
    
    my $current_document = flo::Standard::current_document();
    return unless $current_document->Can_Admin;
    
    my $cgi = flo::Standard::cgi();
    my $path_info = $cgi->path_info;
    
    $path_info =~ /,copy$/ || return;
    
    return 1;
}


##
# $self->http_get();
# ------------------
# Processes an incoming HTTP GET query.
##
sub http_get
{
    my $self = shift;
    my $doc  = flo::Standard::current_document();
    $self->render_http (
	self       => $self,
	__input__  => 'XML',
	__output__ => 'XHTML',
       );
    
    return 'TERMINATE';
}


sub _validate_defined
{
    my $self = shift;
    my $to = shift;
    defined $to and $to or do {
	new MKDoc::Ouch 'document/move/no_target';
	return 0;
    };
    return 1;
}


sub _validate_exists
{
    my $self = shift;
    my $to   = shift;
    my $document_t = flo::Standard::table ('Document');
    $document_t->get ($to) or do {
	new MKDoc::Ouch 'document/move/no_target';
	return 0;
    };
    return 1;
}


sub _validate_perms
{
    my $self = shift;
    my $to   = shift;
    my $document_t = flo::Standard::table ('Document');
    my $doc  = $document_t->get ($to);
    $doc->Can_Admin() or do {
	new MKDoc::Ouch 'document/move/denied';
	return 0;
    };
    return 1;
}


sub redirect
{    
    my $self = shift;
    my $doc  = shift;
    my $cgix = flo::Standard::cgi()->new();
    $cgix->path_info ($doc->path());
    $cgix->delete ($cgix->param());
    print $cgix->redirect ($cgix->self_url);
}


sub http_post
{
    my $self  = shift;
    my $cgix  = flo::Standard::cgi()->new();
    my $to    = $cgix->param ('to');
    my $cmp   = $self->component();
    
    $self->_validate_defined ($to) || return $self->http_get();
    $self->_validate_exists  ($to) || return $self->http_get();
    $self->_validate_perms   ($to) || return $self->http_get();
    
    my $document_t = flo::Standard::table ('Document');
    my $new_parent = $document_t->get ($to);
    
    $cmp->copy_to ($new_parent);
    $self->has_errors() and return $self->http_get();
    
    $self->redirect ($new_parent);
    return 'TERMINATE';
}


sub movable_document_list
{
    my $self = shift;
    
    my $document_t = flo::Standard::table ('Document');
    my $query = $document_t->select (
	cols   => [ qw /ID Parent_ID Cache_Control Template Description Keywords
			Date_Created Date_Last_Modified Editor_Created_ID Editor_Last_Modified_ID
			Name Full_Path Title Lang Rights Publisher Source Relation Coverage
			Sibling_Position Sort_By Order_By/ ], 
	sort   => [ 'Full_Path' ],
	desc   => 0
       );
    
    my @res = ();
    while (my $doc = $query->next())
    {
	push @res, $doc if ($doc->Can_Admin());
    }
    
    return wantarray ? @res : \@res;
}


1;
