# -------------------------------------------------------------------
# flo::plugin::Cache::Reader
# -------------------------------------------------------------------
# Author: Jean-Michel Hiver <jhiver@mkdoc.com>
# Copyright: (c) MKDoc Holdings Ltd, 2003
# Description: flo::plugin::Cache::Reader tries to fetch cached
# data for the current document and returns it.
# -------------------------------------------------------------------
package flo::plugin::Cache::Reader;
use strict;
use warnings;
use Encode;
use Carp;
use flo::Standard;
use flo::HTTP::Header;
use Cache::FileCache;
use 5.008_000;

use base qw /flo::DocumentPlugin/;


sub name { '' }


sub run
{
    my $self  = shift;
    my $cache = $self->cache_object();
    my $uri   = flo::Standard::cgi()->self_url();
    my $data  = $cache->get ($uri) || return;
    $self->send_data ($data);
    return 'TERMINATE';
}


sub mode
{
    my $self = shift;
    my $mode = 'public';
    return $mode;
}


sub is_mode
{
    my $self = shift;
    my $mode = shift;
    return $mode eq $self->mode;
}


sub send_data
{
    my $self = shift;
    my $data = shift;
    
    use bytes;
    my $header = new flo::HTTP::Header();
    $header->set ('Content-Type: text/html; charset=UTF-8');
    no bytes;
    
    $header = $header->header;
    Encode::_utf8_off ($header);
    Encode::_utf8_off ($data);
    
    my $req_method = $ENV{REQUEST_METHOD} || 'GET';
    if ($req_method =~ /^HEAD$/i) { print $header         }
    else                          { print $header . $data }
}


sub cache_object
{
    my $self = shift;
    my %opt  = (
        cache_root => MKDoc::Config->CACHE_DIR,
	namespace  => 'document',
       );
    
    return new Cache::FileCache ( \%opt );
}


1;
