# -------------------------------------------------------------------------------------
# flo::plugin::Discussion::View
# -------------------------------------------------------------------------------------
#
#       Author : Jean-Michel Hiver <jhiver@mkdoc.com>
#    Copyright : (c) MKDoc Holdings Ltd, 2002
#
#      Unauthorized modification, use, reuse, distribution or redistribution
#      of this module is stricly forbidden
#
#    Description:
#
# -------------------------------------------------------------------------------------
package flo::plugin::Discussion::View;
use MKDoc::Config;
use flo::ComponentPlugin;
use flo::HTTP::Header;
use flo::plugin::Discussion::IMAP;
use flo::plugin::Discussion::Message;
use flo::Standard qw /cgi/;
use strict;
use warnings;
use 5.008_000;
use Carp;

use base qw /flo::plugin::Discussion::List/;


# yet another horrible hack
sub ancestors
{
    my $self = shift;
    my @res  = ($self->SUPER::ancestors, $self->component);
    return wantarray ? @res : \@res;
}


sub type   { 'discussion' }
sub cgi_do { 'view'       }


sub activate
{
    my $self = shift;
    $self->SUPER::_activate_passthru() || return;
    
    my $cgi = flo::Standard::cgi();
    my $path_info = $cgi->path_info;
    
    my $hint = quotemeta (MKDoc::Config->IMAP_VIEW_URI_HINT);
    $path_info =~ /\,$hint$/ || return;
    
    my $component = $self->component;
    $component->isa ('flo::editor::Discussion') || return;
    
    my $uid = $cgi->param ('uid') || return;
    $self->_initialize_after_activate;
    
    # if there was an error during initialization, we want to activate in order
    # to send an error page
    return 1 if ($self->{error});
    
    # if there is no valid 'uid' parameter, then flo::plugin::Discussion::View
    # should *NOT* be activated
    return unless (defined $uid and $uid and $uid =~ /^\d+$/);
    
    my $imap = new flo::plugin::Discussion::IMAP();
    return unless ($imap->message_exists ($uid));    
    
    # everything is fine, let's do a tiny bit of extra init
    $self->{template} = 'discussion/view';
    return 1;
}


##
# $self->current_slice;
# ---------------------
#   Returns the current slice that we're onto
##
sub current_slice
{
    my $self = shift;
    my $cgi = cgi();
    my $uid = $cgi->param ('uid') || return;
    
    my $count;
    for my $slice (@{$self->{slices}})
    {
	for (@{$slice->{uids}})
	{
	    return $slice if ($uid == $_);
	}
    }
    
    return $self->SUPER::current_slice;
}


##
# $self->message;
# ---------------
#   Returns the current message that is being viewed.
##
sub message
{
    my $self = shift;
    my $cgix = cgi->new;
    my $uid  = $cgix->param ('uid');
    my $thread = $self->top_thread;
    return $thread->get ($uid);
}


##
# $self->template_path;
# ---------------------
#   Returns the directory path which is supposed to contain the language
#   template files. This method is there just to be subclassed.
##
sub template_path
{
    my $self = shift;
    return $self->{template};  
}


##
# $self->run;
# -----------
#   Displays a list of messages.
##
sub run
{
    my $self = shift;
    
    $self->render_http (
	__input__  => 'XML',
	__output__ => 'XHTML',
	self       => $self,
	object     => $self->component,
       );
    
    return 'TERMINATE';
}


sub uri
{
    my $self = shift;
    my $uri  = $self->SUPER::uri();
    warn $uri;
    $uri .= "," . MKDoc::Config->IMAP_VIEW_URI_HINT;
    return $uri;
}


1;
